/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.scl.db;

import org.simantics.db.Resource;
import org.simantics.db.request.QueryFactoryKey;
import org.simantics.db.request.QuerySerializer;
import org.simantics.scl.runtime.function.Function;

public class SubqueryRMS extends SubqueryR<String> {

	@SuppressWarnings("rawtypes")
	public SubqueryRMS(Resource r, Function f) {
		super(r, id(f));
	}

	public SubqueryRMS(Resource r, String id) {
		super(r, id);
	}

	@Override
	public void serializeValue(QuerySerializer serializer, String value) {
		if(value != null) {
			serializer.addByte((byte)1);
			serializer.addString(value);
		} else {
			serializer.addByte((byte)0);
		}
	}

	private static final QueryFactoryKey queryFactoryKey = new QueryFactoryKey("org.simantics.scl.db", SubqueryRMS.class.getName()); 

	@Override
	public QueryFactoryKey classId() {
		return queryFactoryKey;
	}

}