/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.scl.db;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.PersistentRead;
import org.simantics.db.request.QuerySerializer;
import org.simantics.db.request.ReadExt;
import org.simantics.db.request.RequestFlags;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.runtime.RuntimeModule;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.function.Function;

abstract public class SubqueryR<V> extends BinaryRead<Resource, String, V> implements ReadExt, PersistentRead<V> {

	@SuppressWarnings("rawtypes")
	public SubqueryR(Resource r, Function f) {
		super(r, id(f));
	}

	public SubqueryR(Resource r, String id) {
		super(r, id);
	}

	@SuppressWarnings("rawtypes")
	public static String id(Function f) {
		return f.toString();
	}

	@SuppressWarnings("rawtypes")
	public Function resolveFunction(ReadGraph graph, String id) throws DatabaseException {
		String[] parts = id.split("#");
		String moduleName = parts[0].substring(4);
		Failable<RuntimeModule> mf = SCLOsgi.MODULE_REPOSITORY.getRuntimeModule(moduleName);
		RuntimeModule m = mf.getResult();
		if(m == null) return null;
		try {
			Object result = m.getValue(parts[1]);
			return (Function)result;
		} catch (ValueNotFound e) {
			throw new DatabaseException(e);
		}
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public V perform(ReadGraph graph) throws DatabaseException {
		Function f = resolveFunction(graph, parameter2);
		return (V)Simantics.applySCLRead(graph, f, parameter);
	}

	@Override
	public boolean isImmutable(ReadGraph graph) throws DatabaseException {
		return graph.isImmutable(parameter);
	}

	@Override
	public int getType() {
		return RequestFlags.INVALIDATE;
	}

	public long cacheId(ClusteringSupport support) {
		long clusterId = support.getCluster(parameter); 
		return (clusterId << 1) + 1;
	}

	public void serializeKey(QuerySerializer serializer) {
		serializer.addResource(parameter);
		serializer.addString(parameter2.toString());
	}

}