/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.source.repository;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.junit.Test;
import org.simantics.scl.runtime.SCLContext;

public class ModuleBrowsingUtil {
    public static final String SCL_EXTENSION = ".scl";
    public static final int SCL_EXTENSION_LENGTH = ".scl".length();

    public static void collectModuleSourcesAt(Collection<String> result, URL url) throws IOException {
        String protocol = url.getProtocol();
        if ("jar".equals(protocol)) {
            URLConnection connection = url.openConnection();
            if (!(connection instanceof JarURLConnection)) {
                throw new UnsupportedOperationException("Expected JarURLConnection when opening connection to " + String.valueOf(url) + ".");
            }
            JarURLConnection jarConnection = (JarURLConnection)connection;
            ModuleBrowsingUtil.collectModuleSourcesAt(result, jarConnection.getEntryName(), jarConnection.getJarFile());
        } else if ("file".equals(protocol)) {
            File file = new File(URLDecoder.decode(url.getPath(), "UTF-8"));
            if (!file.exists()) {
                throw new UnsupportedOperationException("File " + String.valueOf(url) + " not found.");
            }
            ModuleBrowsingUtil.collectModuleSourcesAt(result, file);
        } else if ("bundleresource".equals(protocol)) {
            URL localURL;
            URLConnection connection = url.openConnection();
            Class<?> connectionClass = connection.getClass();
            if (!connectionClass.getSimpleName().equals("BundleURLConnection")) {
                throw new UnsupportedOperationException("Expected BundleURLConnection when opening connection to " + String.valueOf(url) + ".");
            }
            try {
                localURL = (URL)connectionClass.getMethod("getLocalURL", new Class[0]).invoke((Object)connection, new Object[0]);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Couldn't browse " + String.valueOf(url) + ".", e);
            }
            ModuleBrowsingUtil.collectModuleSourcesAt(result, localURL);
        } else {
            throw new UnsupportedOperationException("Protocol of " + String.valueOf(url) + " does not support directory browsing.");
        }
    }

    public static void collectModuleSourcesAt(Collection<String> result, File file) {
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            String name = child.getName();
            if (child.isDirectory()) {
                ModuleBrowsingUtil.collectModuleSourcesAt(result, name + "/", child);
            } else if (name.endsWith(SCL_EXTENSION)) {
                result.add(name.substring(0, name.length() - SCL_EXTENSION_LENGTH));
            }
            ++n2;
        }
    }

    private static void collectModuleSourcesAt(Collection<String> result, String prefix, File file) {
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            String name = child.getName();
            if (child.isDirectory()) {
                ModuleBrowsingUtil.collectModuleSourcesAt(result, prefix + name + "/", child);
            } else if (name.endsWith(SCL_EXTENSION)) {
                result.add(prefix + name.substring(0, name.length() - SCL_EXTENSION_LENGTH));
            }
            ++n2;
        }
    }

    private static void collectModuleSourcesAt(Collection<String> result, String entryName, JarFile jarFile) throws IOException {
        JarEntry entry;
        int entryNameLength = entryName.length();
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements() && (entry = e.nextElement()) != null) {
            String name = entry.getName();
            if (!name.startsWith(entryName) || !name.endsWith(SCL_EXTENSION)) continue;
            result.add(name.substring(entryNameLength + 1, name.length() - SCL_EXTENSION_LENGTH));
        }
    }

    @Test
    public void osgiTest() throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        ModuleBrowsingUtil.collectModuleSourcesAt(l, SCLContext.class.getResource("prelude"));
        System.out.println(l);
    }

    public static File toFile(URL url) throws IOException {
        File file;
        String protocol = url.getProtocol();
        if ("file".equals(protocol) && (file = new File(URLDecoder.decode(url.getPath(), "UTF-8"))).exists()) {
            return file;
        }
        return null;
    }
}

