/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.source;

import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.errors.Success;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.options.ModuleCompilationOptions;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ModuleSource;

public class PrecompiledModuleSource
implements ModuleSource {
    private final Module module;
    private final double priority;

    public PrecompiledModuleSource(Module module, double priority) {
        this.module = module;
        this.priority = priority;
    }

    public PrecompiledModuleSource(Module module) {
        this(module, 0.0);
    }

    @Override
    public String getModuleName() {
        return this.module.getName();
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    @Override
    public Failable<Module> compileModule(ModuleRepository environment, UpdateListener listener, ModuleCompilationOptions options) {
        return new Success<Module>(this.module);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    public String toString() {
        return "PrecompiledModuleSource(" + this.module.getName() + ")";
    }
}

