/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.generator.table;

import org.simantics.scl.compiler.parser.generator.grammar.AnaGrammar;
import org.simantics.scl.compiler.parser.generator.grammar.Prod;

public class Item
implements Comparable<Item> {
    public final int production;
    public final int position;
    public int stackPos;

    public Item(int production, int position, int stackPos) {
        this.production = production;
        this.position = position;
        this.stackPos = stackPos;
    }

    public int[] nextSymbols(AnaGrammar grammar) {
        Prod prod = grammar.prods.get(this.production);
        return prod.rhs.nextStates(this.position);
    }

    public int nextPosition(AnaGrammar grammar, int symbol) {
        Prod prod = grammar.prods.get(this.production);
        return prod.rhs.getTransition(this.position, symbol);
    }

    public int hashCode() {
        return (this.production * 31 + this.position) * 31 + this.stackPos;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Item other = (Item)obj;
        return this.production == other.production && this.position == other.position && this.stackPos == other.stackPos;
    }

    @Override
    public int compareTo(Item o) {
        if (this.production < o.production) {
            return -1;
        }
        if (this.production > o.production) {
            return 1;
        }
        if (this.position < o.position) {
            return -1;
        }
        if (this.position > o.position) {
            return 1;
        }
        return 0;
    }

    public String toString(AnaGrammar grammar) {
        Prod prod = grammar.prods.get(this.production);
        StringBuilder b = new StringBuilder();
        b.append(grammar.nonterminalNames[prod.lhs]);
        b.append(" ::= ");
        prod.rhs.toPositionalRegexp(this.position).toString(b, grammar, 0);
        if (this.stackPos >= 0) {
            b.append(" (stack ").append(this.stackPos).append(')');
        }
        return b.toString();
    }

    public boolean isReducible(AnaGrammar grammar) {
        return grammar.prods.get((int)this.production).rhs.getAccepts(this.position);
    }
}

