/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.module.repository;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.ConcreteEnvironment;
import org.simantics.scl.compiler.environment.EmptyEnvironment;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.NamespaceImpl;
import org.simantics.scl.compiler.environment.NamespaceSpec;
import org.simantics.scl.compiler.environment.filter.NamespaceFilter;
import org.simantics.scl.compiler.environment.filter.NamespaceFilters;
import org.simantics.scl.compiler.environment.specification.EnvironmentSpecification;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.DoesNotExist;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.errors.Failure;
import org.simantics.scl.compiler.errors.Success;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.options.ModuleCompilationOptions;
import org.simantics.scl.compiler.module.options.ModuleCompilationOptionsAdvisor;
import org.simantics.scl.compiler.module.repository.ImportFailure;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.runtime.RuntimeEnvironmentImpl;
import org.simantics.scl.compiler.runtime.RuntimeModule;
import org.simantics.scl.compiler.runtime.RuntimeModuleMap;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;
import org.simantics.scl.compiler.top.ModuleInitializer;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleRepository.class);
    private static ModuleCompilationOptions.StoreOption storeOption = ModuleCompilationOptions.StoreOption.NONE;
    private final ModuleRepository parentRepository;
    private final ModuleSourceRepository sourceRepository;
    private ConcurrentHashMap<String, ModuleEntry> moduleCache = new ConcurrentHashMap();
    private static final ThreadLocal<THashSet<String>> PENDING_MODULES = new ThreadLocal();
    private ModuleCompilationOptionsAdvisor advisor = null;
    private Path location = null;

    static {
        storeOption = ModuleCompilationOptions.StoreOption.parse(System.getProperty("scl.store"));
    }

    private static void beginModuleCompilation(String moduleName) {
        THashSet set = PENDING_MODULES.get();
        if (set == null) {
            set = new THashSet();
            PENDING_MODULES.set((THashSet<String>)set);
        }
        if (!set.add((Object)moduleName)) {
            throw new IllegalArgumentException("Cyclic module dependency detected at " + moduleName + ".");
        }
    }

    private static void finishModuleCompilation(String moduleName) {
        PENDING_MODULES.get().remove((Object)moduleName);
    }

    public ModuleRepository(ModuleRepository parentRepository, ModuleSourceRepository sourceRepository) {
        this.parentRepository = parentRepository;
        this.sourceRepository = sourceRepository;
    }

    public ModuleRepository(ModuleSourceRepository sourceRepository) {
        this(null, sourceRepository);
    }

    public Failable<Module> getModule(String moduleName, UpdateListener listener) {
        return this.getModuleEntry((String)moduleName, (UpdateListener)listener).compilationResult;
    }

    public Failable<Module> getModule(String moduleName) {
        return this.getModule(moduleName, null);
    }

    public void update(String moduleName) {
        this.getModuleEntry(moduleName, null).notifyAboutUpdate();
    }

    public Failable<RuntimeModule> getRuntimeModule(String moduleName, UpdateListener listener) {
        return this.getModuleEntry(moduleName, listener).getRuntimeModule();
    }

    public Failable<RuntimeModule> getRuntimeModule(String moduleName) {
        return this.getRuntimeModule(moduleName, null);
    }

    private ModuleEntry getModuleEntry(String moduleName, UpdateListener listener) {
        ModuleEntry entry = this.moduleCache.get(moduleName);
        if (entry == null) {
            entry = new ModuleEntry(moduleName).initModuleEntryAndAddListener(listener);
        } else {
            entry.addListener(listener);
        }
        if (entry.compilationResult == DoesNotExist.INSTANCE && this.parentRepository != null) {
            return this.parentRepository.getModuleEntry(moduleName, listener);
        }
        return entry;
    }

    private THashMap<String, ModuleEntry> getModuleEntries(CompilationContext compilationContext, ImportDeclaration[] imports, UpdateListener listener, boolean robustly) throws ImportFailureException {
        ImportDeclaration import_;
        THashMap result = new THashMap();
        ArrayList<ImportFailure> failures = null;
        TObjectLongHashMap originalImports = new TObjectLongHashMap();
        ArrayList<ImportDeclaration> stack = new ArrayList<ImportDeclaration>(imports.length);
        ImportDeclaration[] importDeclarationArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            import_ = importDeclarationArray[n2];
            stack.add(import_);
            originalImports.put((Object)import_.moduleName, import_.location);
            ++n2;
        }
        while (!stack.isEmpty()) {
            import_ = (ImportDeclaration)stack.remove(stack.size() - 1);
            if (result.containsKey((Object)import_.moduleName)) continue;
            boolean originalImport = originalImports.contains((Object)import_.moduleName);
            ModuleEntry entry = this.getModuleEntry(import_.moduleName, originalImport ? listener : null);
            Failable<Module> compilationResult = entry.compilationResult;
            if (compilationResult.didSucceed()) {
                String deprecation;
                result.put((Object)import_.moduleName, (Object)entry);
                stack.addAll(compilationResult.getResult().getDependencies());
                if (!originalImport || (deprecation = compilationResult.getResult().getDeprecation()) == null || compilationContext == null) continue;
                long location = originalImport ? originalImports.get((Object)import_.moduleName) : 9223372034707292160L;
                compilationContext.errorLog.logWarning(location, "Deprecated module " + import_.moduleName + (String)(deprecation.isEmpty() ? "." : ": " + deprecation));
                continue;
            }
            if (failures == null) {
                failures = new ArrayList<ImportFailure>(2);
            }
            failures.add(new ImportFailure(import_.location, import_.moduleName, compilationResult == DoesNotExist.INSTANCE ? ImportFailure.MODULE_DOES_NOT_EXIST_REASON : ((Failure)compilationResult).errors));
        }
        if (failures != null && !robustly) {
            throw new ImportFailureException(failures);
        }
        return result;
    }

    private static THashMap<String, Module> mapEntriesToModules(THashMap<String, ModuleEntry> entries) {
        final THashMap result = new THashMap(entries.size());
        entries.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, ModuleEntry>(){

            public boolean execute(String a, ModuleEntry b) {
                result.put((Object)a, (Object)b.compilationResult.getResult());
                return true;
            }
        });
        return result;
    }

    private static THashMap<String, RuntimeModule> mapEntriesToRuntimeModules(THashMap<String, ModuleEntry> entries) {
        final THashMap result = new THashMap(entries.size());
        entries.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, ModuleEntry>(){

            public boolean execute(String a, ModuleEntry b) {
                result.put((Object)a, (Object)b.getRuntimeModule().getResult());
                return true;
            }
        });
        return result;
    }

    public Environment createEnvironment(ImportDeclaration[] imports, UpdateListener listener) throws ImportFailureException {
        return this.createEnvironment(null, imports, listener);
    }

    public Environment createEnvironment(CompilationContext compilationContext, ImportDeclaration[] imports, UpdateListener listener) throws ImportFailureException {
        THashMap<String, ModuleEntry> entries = this.getModuleEntries(compilationContext, imports, listener, false);
        THashMap<String, Module> moduleMap = ModuleRepository.mapEntriesToModules(entries);
        return ModuleRepository.createEnvironment(moduleMap, imports);
    }

    public Environment createEnvironmentRobustly(CompilationContext compilationContext, ImportDeclaration[] imports, UpdateListener listener) {
        try {
            THashMap<String, ModuleEntry> entries = this.getModuleEntries(compilationContext, imports, listener, true);
            THashMap<String, Module> moduleMap = ModuleRepository.mapEntriesToModules(entries);
            return ModuleRepository.createEnvironment(moduleMap, imports);
        }
        catch (ImportFailureException importFailureException) {
            return EmptyEnvironment.INSTANCE;
        }
    }

    public Environment createEnvironment(EnvironmentSpecification specification, UpdateListener listener) throws ImportFailureException {
        return this.createEnvironment(specification.imports.toArray(new ImportDeclaration[specification.imports.size()]), listener);
    }

    public RuntimeEnvironment createRuntimeEnvironment(EnvironmentSpecification environmentSpecification, ClassLoader parentClassLoader) throws ImportFailureException {
        return this.createRuntimeEnvironment(environmentSpecification, parentClassLoader, null);
    }

    public RuntimeEnvironment createRuntimeEnvironment(EnvironmentSpecification environmentSpecification) throws ImportFailureException {
        return this.createRuntimeEnvironment(environmentSpecification, this.getClass().getClassLoader());
    }

    public RuntimeEnvironment createRuntimeEnvironment(EnvironmentSpecification environmentSpecification, ClassLoader parentClassLoader, UpdateListener listener) throws ImportFailureException {
        return this.createRuntimeEnvironment(environmentSpecification.imports.toArray(new ImportDeclaration[environmentSpecification.imports.size()]), parentClassLoader, listener);
    }

    public RuntimeEnvironment createRuntimeEnvironment(ImportDeclaration[] imports, ClassLoader parentClassLoader, UpdateListener listener) throws ImportFailureException {
        THashMap<String, ModuleEntry> entries = this.getModuleEntries(null, imports, listener, false);
        THashMap<String, Module> moduleMap = ModuleRepository.mapEntriesToModules(entries);
        Environment environment = ModuleRepository.createEnvironment(moduleMap, imports);
        THashMap<String, RuntimeModule> runtimeModuleMap = ModuleRepository.mapEntriesToRuntimeModules(entries);
        return new RuntimeEnvironmentImpl(environment, parentClassLoader, runtimeModuleMap);
    }

    private static Environment createEnvironment(THashMap<String, Module> moduleMap, ImportDeclaration[] imports) {
        NamespaceSpec spec = new NamespaceSpec();
        ImportDeclaration[] importDeclarationArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            ImportDeclaration import_ = importDeclarationArray[n2];
            if (import_.localName != null) {
                ModuleRepository.addToNamespace(moduleMap, spec, import_.moduleName, import_.localName, NamespaceFilters.createFromSpec(import_.spec));
            }
            ++n2;
        }
        return new ConcreteEnvironment(moduleMap, spec.toNamespace());
    }

    private static void addToNamespace(THashMap<String, Module> moduleMap, NamespaceSpec namespace, String moduleName, String localName, NamespaceFilter filter) {
        if (localName.isEmpty()) {
            ModuleRepository.addToNamespace(moduleMap, namespace, moduleName, filter);
        } else {
            ModuleRepository.addToNamespace(moduleMap, namespace.getNamespace(localName), moduleName, filter);
        }
    }

    private static void addToNamespace(THashMap<String, Module> moduleMap, NamespaceSpec namespace, String moduleName, NamespaceFilter filter) {
        block4: {
            NamespaceImpl.ModuleImport moduleImport;
            block3: {
                moduleImport = (NamespaceImpl.ModuleImport)namespace.moduleMap.get((Object)moduleName);
                if (moduleImport != null) break block3;
                Module module = (Module)moduleMap.get((Object)moduleName);
                namespace.moduleMap.put((Object)moduleName, (Object)new NamespaceImpl.ModuleImport(module, filter));
                for (ImportDeclaration import_ : module.getDependencies()) {
                    if (import_.localName == null) continue;
                    NamespaceFilter localFilter = NamespaceFilters.createFromSpec(import_.spec);
                    if (import_.localName.equals("")) {
                        localFilter = NamespaceFilters.intersection(filter, localFilter);
                    }
                    ModuleRepository.addToNamespace(moduleMap, namespace, import_.moduleName, import_.localName, localFilter);
                }
                break block4;
            }
            if (filter.isSubsetOf(moduleImport.filter)) break block4;
            moduleImport.filter = NamespaceFilters.union(moduleImport.filter, filter);
            for (ImportDeclaration import_ : moduleImport.module.getDependencies()) {
                if (!"".equals(import_.localName)) continue;
                NamespaceFilter localFilter = NamespaceFilters.createFromSpec(import_.spec);
                localFilter = NamespaceFilters.intersection(filter, localFilter);
                ModuleRepository.addToNamespace(moduleMap, namespace, import_.moduleName, import_.localName, localFilter);
            }
        }
    }

    public Object getValue(String moduleName, String valueName) throws ValueNotFound {
        Failable<RuntimeModule> module = this.getRuntimeModule(moduleName);
        if (module.didSucceed()) {
            return module.getResult().getValue(valueName);
        }
        if (module == DoesNotExist.INSTANCE) {
            throw new ValueNotFound("Didn't find module " + moduleName);
        }
        throw new ValueNotFound(((Failure)module).toString());
    }

    public Object getValue(String fullValueName) throws ValueNotFound {
        int p = fullValueName.lastIndexOf(47);
        if (p < 0) {
            throw new ValueNotFound(fullValueName + " is not a valid full value name.");
        }
        return this.getValue(fullValueName.substring(0, p), fullValueName.substring(p + 1));
    }

    public SCLValue getValueRef(String moduleName, String valueName) throws ValueNotFound {
        Failable<Module> module = this.getModule(moduleName);
        if (module.didSucceed()) {
            SCLValue value = module.getResult().getValue(valueName);
            if (value == null) {
                throw new ValueNotFound("Module " + moduleName + " does not contain value " + valueName + ".");
            }
            return value;
        }
        if (module == DoesNotExist.INSTANCE) {
            throw new ValueNotFound("Didn't find module " + moduleName);
        }
        throw new ValueNotFound(((Failure)module).toString());
    }

    public SCLValue getValueRef(String fullValueName) throws ValueNotFound {
        int p = fullValueName.lastIndexOf(47);
        if (p < 0) {
            throw new ValueNotFound(fullValueName + " is not a valid full value name.");
        }
        return this.getValueRef(fullValueName.substring(0, p), fullValueName.substring(p + 1));
    }

    public ModuleSourceRepository getSourceRepository() {
        return this.sourceRepository;
    }

    public String getDocumentation(String documentationName) {
        String documentation = this.sourceRepository.getDocumentation(documentationName);
        if (documentation == null && this.parentRepository != null) {
            return this.parentRepository.getDocumentation(documentationName);
        }
        return documentation;
    }

    public void flush() {
        if (this.parentRepository != null) {
            this.parentRepository.flush();
        }
        if (this.moduleCache != null) {
            for (ModuleEntry entry : this.moduleCache.values()) {
                entry.dispose();
            }
        }
        this.moduleCache = new ConcurrentHashMap();
    }

    public Map<String, Module> getModules() {
        HashMap<String, Module> result = new HashMap<String, Module>(this.moduleCache.size());
        for (Map.Entry<String, ModuleEntry> entry : this.moduleCache.entrySet()) {
            ModuleEntry moduleEntry = entry.getValue();
            if (!moduleEntry.compilationResult.didSucceed()) continue;
            result.put(entry.getKey(), moduleEntry.compilationResult.getResult());
        }
        return result;
    }

    public ModuleCompilationOptionsAdvisor getAdvisor() {
        return this.advisor;
    }

    public void setAdvisor(ModuleCompilationOptionsAdvisor advisor) {
        this.advisor = advisor;
    }

    public void setLocation(Path location) {
        this.location = location;
    }

    public Path getLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (this.parentRepository != null) {
            return this.parentRepository.getLocation();
        }
        return null;
    }

    private class ModuleEntry
    extends UpdateListener
    implements UpdateListener.Observable {
        final String moduleName;
        THashSet<UpdateListener> listeners = new THashSet();
        ModuleSource source;
        Failable<Module> compilationResult;
        Failable<RuntimeModule> runtimeModule;

        public ModuleEntry(String moduleName) {
            this.moduleName = moduleName;
        }

        synchronized void addListener(UpdateListener listener) {
            if (listener == null || this.listeners == null) {
                return;
            }
            this.listeners.add((Object)listener);
            listener.addObservable(this);
        }

        @Override
        public synchronized void removeListener(UpdateListener listener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove((Object)listener);
        }

        @Override
        public void notifyAboutUpdate() {
            this.stopListening();
            ArrayList<UpdateListener> externalListeners = new ArrayList<UpdateListener>();
            this.notifyAboutUpdate(externalListeners);
            for (UpdateListener listener : externalListeners) {
                listener.notifyAboutUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyAboutUpdate(ArrayList<UpdateListener> externalListeners) {
            THashSet<UpdateListener> listenersCopy;
            ModuleEntry moduleEntry = this;
            synchronized (moduleEntry) {
                listenersCopy = this.listeners;
                if (listenersCopy == null) {
                    return;
                }
                this.listeners = null;
            }
            if (ModuleRepository.this.moduleCache.get(this.moduleName) == this) {
                ModuleRepository.this.moduleCache.remove(this.moduleName);
                if (SCLCompilerConfiguration.TRACE_MODULE_UPDATE) {
                    LOGGER.info("Invalidate " + this.moduleName);
                    for (UpdateListener l : listenersCopy) {
                        LOGGER.info("    " + String.valueOf(l));
                    }
                }
                for (UpdateListener l : listenersCopy) {
                    if (!l.stopListening()) continue;
                    if (l instanceof ModuleEntry) {
                        ((ModuleEntry)l).notifyAboutUpdate(externalListeners);
                        continue;
                    }
                    externalListeners.add(l);
                }
            }
        }

        private ModuleCompilationOptions moduleCompilationOptions() {
            ModuleCompilationOptions options;
            ModuleCompilationOptions moduleCompilationOptions = options = ModuleRepository.this.advisor == null ? null : ModuleRepository.this.advisor.getOptions(this.moduleName);
            if (options != null && !ModuleCompilationOptions.StoreOption.NONE.equals((Object)storeOption)) {
                boolean updateable = this.source.isUpdateable();
                options = updateable ? options.withStore(ModuleCompilationOptions.StoreOption.NONE) : options.withStore(storeOption);
            }
            return options;
        }

        private ModuleEntry initModuleEntryAndAddListener(UpdateListener listener) {
            this.source = ModuleRepository.this.sourceRepository.getModuleSource(this.moduleName, this);
            if (this.source == null) {
                this.compilationResult = DoesNotExist.getInstance();
            } else {
                if (SCLCompilerConfiguration.TRACE_MODULE_UPDATE) {
                    LOGGER.info("Compile " + String.valueOf(this.source));
                }
                ModuleRepository.beginModuleCompilation(this.moduleName);
                this.compilationResult = this.source.compileModule(ModuleRepository.this, this, this.moduleCompilationOptions());
                ModuleRepository.finishModuleCompilation(this.moduleName);
            }
            ModuleEntry oldEntry = ModuleRepository.this.moduleCache.putIfAbsent(this.moduleName, this);
            if (oldEntry != null) {
                oldEntry.addListener(listener);
                return oldEntry;
            }
            this.addListener(listener);
            return this;
        }

        public synchronized Failable<RuntimeModule> getRuntimeModule() {
            if (this.runtimeModule == null) {
                if (this.compilationResult.didSucceed()) {
                    Module module = this.compilationResult.getResult();
                    RuntimeModuleMap parentModules = new RuntimeModuleMap();
                    if (!this.moduleName.equals("Builtin")) {
                        THashMap<String, ModuleEntry> moduleEntries;
                        parentModules.add(ModuleRepository.this.getRuntimeModule("Builtin").getResult());
                        List<ImportDeclaration> dependencies = module.getDependencies();
                        try {
                            moduleEntries = ModuleRepository.this.getModuleEntries(null, dependencies.toArray(new ImportDeclaration[dependencies.size()]), null, false);
                        }
                        catch (ImportFailureException e) {
                            throw new InternalCompilerError(e);
                        }
                        for (RuntimeModule m : ModuleRepository.mapEntriesToRuntimeModules(moduleEntries).values()) {
                            parentModules.add(m);
                        }
                    }
                    RuntimeModule rm = new RuntimeModule(module, parentModules, module.getParentClassLoader());
                    ModuleInitializer initializer = module.getModuleInitializer();
                    if (initializer != null) {
                        try {
                            initializer.initializeModule(rm.getMutableClassLoader().getClassLoader());
                        }
                        catch (Exception e) {
                            this.compilationResult = new Failure(new CompilationError[]{new CompilationError("Initialization of module " + this.moduleName + " failed: " + e.getMessage())});
                            e.printStackTrace();
                        }
                    }
                    this.runtimeModule = new Success<RuntimeModule>(rm);
                } else {
                    this.runtimeModule = this.compilationResult;
                }
            }
            return this.runtimeModule;
        }

        public synchronized void dispose() {
            this.listeners = null;
            this.stopListening();
            this.source = null;
            this.compilationResult = null;
            if (this.runtimeModule != null && this.runtimeModule.didSucceed()) {
                this.runtimeModule.getResult().dispose();
            }
            this.runtimeModule = null;
        }

        public String toString() {
            return "ModuleEntry@" + this.moduleName + "@" + this.hashCode();
        }
    }
}

