/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.module.coverage;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.coverage.CombinedCoverage;
import org.simantics.scl.compiler.module.coverage.CoverageUtils;
import org.simantics.scl.compiler.module.coverage.ModuleCoverage;
import org.simantics.scl.runtime.profiling.BranchPoint;

public class CoverageBuilder {
    THashMap<String, THashMap<String, BranchPoint[]>> combined = new THashMap();

    public void addCoverage(Module module, final boolean persistOverBranchpointReset) {
        THashMap<String, BranchPoint[]> branchPointMap = module.getBranchPoints();
        if (branchPointMap == null) {
            return;
        }
        THashMap oldBranchPointMap = (THashMap)this.combined.get((Object)module.getName());
        if (oldBranchPointMap == null) {
            oldBranchPointMap = new THashMap();
            this.combined.put((Object)module.getName(), (Object)oldBranchPointMap);
        }
        final THashMap oldBranchPointMap_ = oldBranchPointMap;
        branchPointMap.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, BranchPoint[]>(){

            public boolean execute(String name, BranchPoint[] branchPoints) {
                BranchPoint[] oldBranchPoints = (BranchPoint[])oldBranchPointMap_.get((Object)name);
                if (oldBranchPoints == null) {
                    if (persistOverBranchpointReset) {
                        BranchPoint[] clonedBranchPoints = CoverageBuilder.cloneBranchPoints(branchPoints);
                        oldBranchPointMap_.put((Object)name, (Object)clonedBranchPoints);
                    } else {
                        oldBranchPointMap_.put((Object)name, (Object)branchPoints);
                    }
                } else {
                    CoverageBuilder.combineCounters(oldBranchPoints, branchPoints);
                }
                return true;
            }
        });
    }

    private static BranchPoint[] cloneBranchPoints(BranchPoint[] oldBranchPoints) {
        BranchPoint[] newBranchPoints = new BranchPoint[oldBranchPoints.length];
        int i = 0;
        while (i < oldBranchPoints.length) {
            BranchPoint bp = oldBranchPoints[i];
            BranchPoint[] children = CoverageBuilder.cloneBranchPoints(bp.getChildren());
            newBranchPoints[i] = new BranchPoint(bp.getLocation(), bp.getCodeSize(), children);
            ++i;
        }
        return newBranchPoints;
    }

    private static void combineCounters(BranchPoint[] oldBranchPoints, BranchPoint[] branchPoints) {
        if (oldBranchPoints.length != branchPoints.length) {
            throw new IllegalArgumentException("Incompatible branch points.");
        }
        int i = 0;
        while (i < branchPoints.length) {
            BranchPoint oldBP = oldBranchPoints[i];
            BranchPoint newBP = branchPoints[i];
            if (oldBP.getLocation() != newBP.getLocation()) {
                throw new IllegalArgumentException("Incompatible branch points.");
            }
            oldBP.incrementVisitCounter(newBP.getVisitCounter());
            CoverageBuilder.combineCounters(oldBP.getChildren(), newBP.getChildren());
            ++i;
        }
    }

    public CombinedCoverage getCoverage() {
        final THashMap moduleCoverages = new THashMap();
        this.combined.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, THashMap<String, BranchPoint[]>>(){

            public boolean execute(String name, THashMap<String, BranchPoint[]> branchPoints) {
                moduleCoverages.put((Object)name, (Object)CoverageUtils.getCoverage(name, branchPoints));
                return true;
            }
        });
        return CoverageUtils.combineCoverages((THashMap<String, ModuleCoverage>)moduleCoverages);
    }
}

