/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.interpreted;

import java.util.Arrays;
import java.util.Objects;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.scl.runtime.function.FunctionImpl2;
import org.simantics.scl.runtime.function.FunctionImpl3;
import org.simantics.scl.runtime.function.FunctionImpl4;
import org.simantics.scl.runtime.function.FunctionImplN;

public class ILambda
implements IExpression {
    private final int[] inheritedVariableIds;
    private final int arity;
    private final int variableBindingsLength;
    private final IExpression body;

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.inheritedVariableIds);
        result = 31 * result + Objects.hash(this.arity, this.body, this.variableBindingsLength);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ILambda other = (ILambda)obj;
        if (this.arity != other.arity) {
            return false;
        }
        if (!Objects.equals(this.body, other.body)) {
            return Objects.equals(this.body, other.body);
        }
        return Arrays.equals(this.inheritedVariableIds, other.inheritedVariableIds) && this.variableBindingsLength == other.variableBindingsLength;
    }

    public ILambda(int[] inheritedVariableIds, int arity, int variableBindingsLength, IExpression body) {
        this.inheritedVariableIds = inheritedVariableIds;
        this.arity = arity;
        this.variableBindingsLength = variableBindingsLength;
        this.body = body;
    }

    @Override
    public Object execute(Object[] variableBindings) {
        Object[] inheritedVariableBindings = new Object[this.inheritedVariableIds.length];
        int i = 0;
        while (i < this.inheritedVariableIds.length) {
            inheritedVariableBindings[i] = variableBindings[this.inheritedVariableIds[i]];
            ++i;
        }
        switch (this.arity) {
            case 1: {
                return new Arity1Func(inheritedVariableBindings);
            }
            case 2: {
                return new Arity2Func(inheritedVariableBindings);
            }
            case 3: {
                return new Arity3Func(inheritedVariableBindings);
            }
            case 4: {
                return new Arity4Func(inheritedVariableBindings);
            }
        }
        return new ArityNFunc(inheritedVariableBindings);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(\\");
        int i = 0;
        while (i < this.inheritedVariableIds.length) {
            b.append('v').append(i).append("(v").append(this.inheritedVariableIds[i]).append(") ");
            ++i;
        }
        i = 0;
        while (i < this.arity) {
            b.append('v').append(i + this.inheritedVariableIds.length).append(' ');
            ++i;
        }
        b.append("-> ");
        b.append(this.body);
        b.append(')');
        return b.toString();
    }

    public String toString(Object[] variableBindings) {
        StringBuilder sb = new StringBuilder();
        ILambda.appendVariableBindings(sb, variableBindings);
        sb.append(this.toString());
        return sb.toString();
    }

    private static void appendVariableBindings(StringBuilder sb, Object[] variableBindings) {
        if (variableBindings.length > 0) {
            sb.append("(let {");
            int i = 0;
            while (i < variableBindings.length) {
                if (i > 0) {
                    sb.append("; ");
                }
                sb.append("v").append(i).append("=").append(variableBindings[i].toString());
                ++i;
            }
            sb.append("} in ");
        }
    }

    private final class Arity1Func
    extends FunctionImpl1 {
        private final Object[] inheritedVariableBindings;

        private Arity1Func(Object[] inheritedVariableBindings) {
            this.inheritedVariableBindings = inheritedVariableBindings;
        }

        public Object apply(Object param0) {
            Object[] newVariableBindings = new Object[ILambda.this.variableBindingsLength];
            int i = 0;
            while (i < this.inheritedVariableBindings.length) {
                newVariableBindings[i] = this.inheritedVariableBindings[i];
                ++i;
            }
            newVariableBindings[i] = param0;
            return ILambda.this.body.execute(newVariableBindings);
        }

        public String toString() {
            return ILambda.this.toString(this.inheritedVariableBindings);
        }

        public int hashCode() {
            return ILambda.this.hashCode() + 31 * Arrays.hashCode(this.inheritedVariableBindings);
        }

        private ILambda getParent() {
            return ILambda.this;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Arity1Func other = (Arity1Func)((Object)obj);
            return ILambda.this.equals(other.getParent()) && Arrays.equals(this.inheritedVariableBindings, other.inheritedVariableBindings);
        }
    }

    private final class Arity2Func
    extends FunctionImpl2 {
        private final Object[] inheritedVariableBindings;

        private Arity2Func(Object[] inheritedVariableBindings) {
            this.inheritedVariableBindings = inheritedVariableBindings;
        }

        public Object apply(Object param0, Object param1) {
            Object[] newVariableBindings = new Object[ILambda.this.variableBindingsLength];
            int i = 0;
            while (i < this.inheritedVariableBindings.length) {
                newVariableBindings[i] = this.inheritedVariableBindings[i];
                ++i;
            }
            newVariableBindings[i++] = param0;
            newVariableBindings[i] = param1;
            return ILambda.this.body.execute(newVariableBindings);
        }

        public String toString() {
            return ILambda.this.toString(this.inheritedVariableBindings);
        }

        public int hashCode() {
            return ILambda.this.hashCode() + 31 * Arrays.hashCode(this.inheritedVariableBindings);
        }

        private ILambda getParent() {
            return ILambda.this;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Arity2Func other = (Arity2Func)((Object)obj);
            return ILambda.this == other.getParent() && Arrays.equals(this.inheritedVariableBindings, other.inheritedVariableBindings);
        }
    }

    private final class Arity3Func
    extends FunctionImpl3 {
        private final Object[] inheritedVariableBindings;

        private Arity3Func(Object[] inheritedVariableBindings) {
            this.inheritedVariableBindings = inheritedVariableBindings;
        }

        public Object apply(Object param0, Object param1, Object param2) {
            Object[] newVariableBindings = new Object[ILambda.this.variableBindingsLength];
            int i = 0;
            while (i < this.inheritedVariableBindings.length) {
                newVariableBindings[i] = this.inheritedVariableBindings[i];
                ++i;
            }
            newVariableBindings[i++] = param0;
            newVariableBindings[i++] = param1;
            newVariableBindings[i] = param2;
            return ILambda.this.body.execute(newVariableBindings);
        }

        public String toString() {
            return ILambda.this.toString(this.inheritedVariableBindings);
        }

        public int hashCode() {
            return ILambda.this.hashCode() + 31 * Arrays.hashCode(this.inheritedVariableBindings);
        }

        private ILambda getParent() {
            return ILambda.this;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Arity3Func other = (Arity3Func)((Object)obj);
            return ILambda.this == other.getParent() && Arrays.equals(this.inheritedVariableBindings, other.inheritedVariableBindings);
        }
    }

    private final class Arity4Func
    extends FunctionImpl4 {
        private final Object[] inheritedVariableBindings;

        private Arity4Func(Object[] inheritedVariableBindings) {
            this.inheritedVariableBindings = inheritedVariableBindings;
        }

        public Object apply(Object param0, Object param1, Object param2, Object param3) {
            Object[] newVariableBindings = new Object[ILambda.this.variableBindingsLength];
            int i = 0;
            while (i < this.inheritedVariableBindings.length) {
                newVariableBindings[i] = this.inheritedVariableBindings[i];
                ++i;
            }
            newVariableBindings[i++] = param0;
            newVariableBindings[i++] = param1;
            newVariableBindings[i++] = param2;
            newVariableBindings[i] = param3;
            return ILambda.this.body.execute(newVariableBindings);
        }

        public String toString() {
            return ILambda.this.toString(this.inheritedVariableBindings);
        }

        public int hashCode() {
            return ILambda.this.hashCode() + 31 * Arrays.hashCode(this.inheritedVariableBindings);
        }

        private ILambda getParent() {
            return ILambda.this;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Arity4Func other = (Arity4Func)((Object)obj);
            return ILambda.this == other.getParent() && Arrays.equals(this.inheritedVariableBindings, other.inheritedVariableBindings);
        }
    }

    private final class ArityNFunc
    extends FunctionImplN {
        private final Object[] inheritedVariableBindings;

        private ArityNFunc(Object[] inheritedVariableBindings) {
            super(ILambda.this.arity);
            this.inheritedVariableBindings = inheritedVariableBindings;
        }

        public Object doApply(Object ... ps) {
            Object[] newVariableBindings = new Object[ILambda.this.variableBindingsLength];
            int i = 0;
            while (i < this.inheritedVariableBindings.length) {
                newVariableBindings[i] = this.inheritedVariableBindings[i];
                ++i;
            }
            Object[] objectArray = ps;
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                Object p = objectArray[n2];
                newVariableBindings[i++] = p;
                ++n2;
            }
            return ILambda.this.body.execute(newVariableBindings);
        }

        public String toString() {
            return ILambda.this.toString(this.inheritedVariableBindings);
        }

        public int hashCode() {
            return ILambda.this.hashCode() + 31 * Arrays.hashCode(this.inheritedVariableBindings);
        }

        private ILambda getParent() {
            return ILambda.this;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            ArityNFunc other = (ArityNFunc)((Object)obj);
            return ILambda.this == other.getParent() && Arrays.equals(this.inheritedVariableBindings, other.inheritedVariableBindings);
        }
    }
}

