/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.constraints2;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.internal.elaboration.constraints2.ConstraintHandle;
import org.simantics.scl.compiler.internal.elaboration.constraints2.ConstraintResolution;
import org.simantics.scl.compiler.internal.elaboration.constraints2.ConstraintSolver;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

class ConstraintStore {
    private final ConstraintSolver solver;
    private final TypeClass typeClass;
    private final THashMap<Type, ArrayList<ConstraintHandle>> constraintsByHead = new THashMap();
    private final ArrayList<ConstraintHandle> constraintsWithoutHead = new ArrayList();

    public ConstraintStore(ConstraintSolver solver, TCon typeClassCon) {
        this.solver = solver;
        this.typeClass = solver.environment.getTypeClass(typeClassCon);
        if (this.typeClass == null) {
            throw new InternalCompilerError("Didn't find type class " + String.valueOf(typeClassCon) + ".");
        }
    }

    private ArrayList<ConstraintHandle> getConstraintListFor(TPred pred) {
        Type head = ConstraintStore.head(pred);
        if (head instanceof TCon || head instanceof TVar) {
            ArrayList result = (ArrayList)this.constraintsByHead.get((Object)head);
            if (result == null) {
                result = new ArrayList(2);
                this.constraintsByHead.put((Object)head, result);
            }
            return result;
        }
        return this.constraintsWithoutHead;
    }

    public ConstraintHandle addConstraint(TPred pred, long demandLocation) {
        ConstraintHandle handle2;
        ArrayList<ConstraintHandle> handles = this.getConstraintListFor(pred);
        for (ConstraintHandle handle2 : handles) {
            if (!ConstraintStore.equals(pred.parameters, handle2.constraint.parameters)) continue;
            return handle2;
        }
        handle2 = new ConstraintHandle(pred, demandLocation);
        handles.add(handle2);
        this.addSuperDemands(handle2);
        return handle2;
    }

    private void addSuperDemands(ConstraintHandle handle) {
        int i = 0;
        while (i < this.typeClass.context.length) {
            TPred superPred = (TPred)this.typeClass.context[i].replace(this.typeClass.parameters, handle.constraint.parameters);
            ConstraintHandle superHandle = this.solver.addDemand(superPred, handle.demandLocation);
            superHandle.setResolution(new ConstraintResolution(this.typeClass.superGenerators[i], handle.constraint.parameters, new ConstraintHandle[]{handle}, 2));
            ++i;
        }
    }

    private static Type head(TPred pred) {
        return pred.parameters[0].head();
    }

    private static boolean equals(Type[] a, Type[] b) {
        int i = 0;
        while (i < a.length) {
            if (!Types.equals(a[i], b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void print(final TypeUnparsingContext tuc) {
        this.constraintsByHead.forEachValue((TObjectProcedure)new TObjectProcedure<ArrayList<ConstraintHandle>>(){

            public boolean execute(ArrayList<ConstraintHandle> constraintHandles) {
                for (ConstraintHandle constraintHandle : constraintHandles) {
                    System.out.println(constraintHandle.toString(tuc));
                }
                return true;
            }
        });
        for (ConstraintHandle constraintHandle : this.constraintsWithoutHead) {
            System.out.println(constraintHandle.toString(tuc));
        }
    }
}

