/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.constraints;

import gnu.trove.map.hash.THashMap;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.constants.ClassConstant;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.JavaConstructor;
import org.simantics.scl.compiler.constants.JavaStaticField;
import org.simantics.scl.compiler.constants.JavaStaticMethod;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.internal.elaboration.constraints.Reduction;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.MultiApply;

public class ReduceSerializable {
    private static final TVar A = Types.var(Kinds.STAR);
    private static final TVar B = Types.var(Kinds.STAR);
    private static final Type SERIALIZABLE_BOOLEAN = Types.pred(Types.SERIALIZABLE, Types.BOOLEAN);
    private static final Type SERIALIZABLE_BYTE = Types.pred(Types.SERIALIZABLE, Types.BYTE);
    private static final Type SERIALIZABLE_INTEGER = Types.pred(Types.SERIALIZABLE, Types.INTEGER);
    private static final Type SERIALIZABLE_LONG = Types.pred(Types.SERIALIZABLE, Types.LONG);
    private static final Type SERIALIZABLE_FLOAT = Types.pred(Types.SERIALIZABLE, Types.FLOAT);
    private static final Type SERIALIZABLE_DOUBLE = Types.pred(Types.SERIALIZABLE, Types.DOUBLE);
    private static final Type SERIALIZABLE_STRING = Types.pred(Types.SERIALIZABLE, Types.STRING);
    private static final Type SERIALIZABLE_BOOLEAN_ARRAY = Types.pred(Types.SERIALIZABLE, Types.BOOLEAN_ARRAY);
    private static final Type SERIALIZABLE_BYTE_ARRAY = Types.pred(Types.SERIALIZABLE, Types.BYTE_ARRAY);
    private static final Type SERIALIZABLE_INTEGER_ARRAY = Types.pred(Types.SERIALIZABLE, Types.INTEGER_ARRAY);
    private static final Type SERIALIZABLE_LONG_ARRAY = Types.pred(Types.SERIALIZABLE, Types.LONG_ARRAY);
    private static final Type SERIALIZABLE_FLOAT_ARRAY = Types.pred(Types.SERIALIZABLE, Types.FLOAT_ARRAY);
    private static final Type SERIALIZABLE_DOUBLE_ARRAY = Types.pred(Types.SERIALIZABLE, Types.DOUBLE_ARRAY);
    private static final Type SERIALIZABLE_BOOLEAN_VECTOR = Types.pred(Types.SERIALIZABLE, Types.pred(Types.VECTOR, Types.BOOLEAN));
    private static final Type SERIALIZABLE_BYTE_VECTOR = Types.pred(Types.SERIALIZABLE, Types.pred(Types.VECTOR, Types.BYTE));
    private static final Type SERIALIZABLE_INTEGER_VECTOR = Types.pred(Types.SERIALIZABLE, Types.pred(Types.VECTOR, Types.INTEGER));
    private static final Type SERIALIZABLE_LONG_VECTOR = Types.pred(Types.SERIALIZABLE, Types.pred(Types.VECTOR, Types.LONG));
    private static final Type SERIALIZABLE_FLOAT_VECTOR = Types.pred(Types.SERIALIZABLE, Types.pred(Types.VECTOR, Types.FLOAT));
    private static final Type SERIALIZABLE_DOUBLE_VECTOR = Types.pred(Types.SERIALIZABLE, Types.pred(Types.VECTOR, Types.DOUBLE));
    private static final Type SERIALIZABLE_TUPLE0 = Types.pred(Types.SERIALIZABLE, Types.tuple(new Type[0]));
    private static final Type SERIALIZABLE_VARIANT = Types.pred(Types.SERIALIZABLE, Types.VARIANT);
    private static final TCon MLIST = Types.con("MList", "T");
    private static final TCon MAP = Types.con("Map", "T");
    private static final TCon MMAP = Types.con("MMap", "T");
    private static Constant GET_BINDING = new JavaStaticMethod("org/simantics/databoard/Bindings", "getBinding", (Type)Types.NO_EFFECTS, (Type)Types.pred(Types.SERIALIZABLE, A), Types.pred(Types.VEC_COMP, A));
    private static final THashMap<TCon, Constant> BINDING_CONSTANTS0 = new THashMap();
    private static final THashMap<TCon, Constant> BINDING_CONSTANTS1;
    private static final THashMap<TCon, Constant> VECTOR_BINDING_CONSTANTS;
    private static final THashMap<TCon, Constant> BINDING_CONSTANTS2;

    static {
        BINDING_CONSTANTS0.put((Object)Types.DOUBLE, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "DOUBLE", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/DoubleBinding"), SERIALIZABLE_DOUBLE, -1));
        BINDING_CONSTANTS0.put((Object)Types.STRING, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "STRING", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/StringBinding"), SERIALIZABLE_STRING, -1));
        BINDING_CONSTANTS0.put((Object)Types.INTEGER, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "INTEGER", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/IntegerBinding"), SERIALIZABLE_INTEGER, -1));
        BINDING_CONSTANTS0.put((Object)Types.BOOLEAN, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "BOOLEAN", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/BooleanBinding"), SERIALIZABLE_BOOLEAN, -1));
        BINDING_CONSTANTS0.put((Object)Types.BYTE, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "BYTE", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ByteBinding"), SERIALIZABLE_BYTE, -1));
        BINDING_CONSTANTS0.put((Object)Types.FLOAT, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "FLOAT", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/FloatBinding"), SERIALIZABLE_FLOAT, -1));
        BINDING_CONSTANTS0.put((Object)Types.LONG, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "LONG", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/LongBinding"), SERIALIZABLE_LONG, -1));
        BINDING_CONSTANTS0.put((Object)Types.UNIT, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "VOID", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/Binding"), SERIALIZABLE_TUPLE0, -1));
        BINDING_CONSTANTS0.put((Object)Types.VARIANT, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "VARIANT", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/VariantBinding"), SERIALIZABLE_VARIANT, -1));
        BINDING_CONSTANTS1 = new THashMap();
        BINDING_CONSTANTS1.put((Object)Types.LIST, (Object)new JavaConstructor("org/simantics/databoard/binding/impl/ArrayListBinding", (Type)Types.NO_EFFECTS, (Type)Types.pred(Types.SERIALIZABLE, Types.list(A)), Types.pred(Types.SERIALIZABLE, A)));
        BINDING_CONSTANTS1.put((Object)Types.MAYBE, (Object)new JavaConstructor("org/simantics/databoard/binding/impl/OptionalBindingDefault", (Type)Types.NO_EFFECTS, (Type)Types.pred(Types.SERIALIZABLE, Types.apply((Type)Types.MAYBE, (Type)A)), Types.pred(Types.SERIALIZABLE, A)));
        BINDING_CONSTANTS1.put((Object)Types.VECTOR, (Object)new JavaStaticMethod("org/simantics/databoard/Bindings", "getArrayBinding", (Type)Types.NO_EFFECTS, (Type)Types.pred(Types.SERIALIZABLE, Types.pred(Types.VECTOR, A)), Types.pred(Types.SERIALIZABLE, A)));
        BINDING_CONSTANTS1.put((Object)MLIST, (Object)new JavaConstructor("org/simantics/databoard/binding/impl/ArrayListBinding", (Type)Types.NO_EFFECTS, (Type)Types.pred(Types.SERIALIZABLE, Types.apply((Type)MLIST, (Type)A)), Types.pred(Types.SERIALIZABLE, A)));
        VECTOR_BINDING_CONSTANTS = new THashMap();
        VECTOR_BINDING_CONSTANTS.put((Object)Types.DOUBLE, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "DOUBLE_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"), SERIALIZABLE_DOUBLE_VECTOR, -1));
        VECTOR_BINDING_CONSTANTS.put((Object)Types.INTEGER, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "INT_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"), SERIALIZABLE_INTEGER_VECTOR, -1));
        VECTOR_BINDING_CONSTANTS.put((Object)Types.BOOLEAN, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "BOOLEAN_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"), SERIALIZABLE_BOOLEAN_VECTOR, -1));
        VECTOR_BINDING_CONSTANTS.put((Object)Types.BYTE, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "BYTE_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"), SERIALIZABLE_BYTE_VECTOR, -1));
        VECTOR_BINDING_CONSTANTS.put((Object)Types.FLOAT, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "FLOAT_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"), SERIALIZABLE_FLOAT_VECTOR, -1));
        VECTOR_BINDING_CONSTANTS.put((Object)Types.LONG, (Object)new JavaStaticField("org/simantics/databoard/Bindings", "LONG_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"), SERIALIZABLE_LONG_VECTOR, -1));
        BINDING_CONSTANTS2 = new THashMap();
        BINDING_CONSTANTS2.put((Object)MAP, (Object)new JavaConstructor("org/simantics/databoard/binding/impl/DefaultMapBinding", (Type)Types.NO_EFFECTS, (Type)Types.pred(Types.SERIALIZABLE, Types.apply((Type)MAP, A, B)), Types.pred(Types.SERIALIZABLE, A), Types.pred(Types.SERIALIZABLE, B)));
        BINDING_CONSTANTS2.put((Object)MMAP, (Object)new JavaConstructor("org/simantics/databoard/binding/impl/DefaultMapBinding", (Type)Types.NO_EFFECTS, (Type)Types.pred(Types.SERIALIZABLE, Types.apply((Type)MMAP, A, B)), Types.pred(Types.SERIALIZABLE, A), Types.pred(Types.SERIALIZABLE, B)));
    }

    public static Reduction reduceSerializable(Type parameter) {
        MultiApply apply = Types.matchApply(parameter);
        if (!(apply.constructor instanceof TCon)) {
            return null;
        }
        switch (apply.parameters.length) {
            case 0: {
                Constant constant = (Constant)BINDING_CONSTANTS0.get((Object)apply.constructor);
                if (constant == null) break;
                return new Reduction(new ELiteral(constant), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
            }
            case 1: {
                Constant vecConstant;
                Type parameter0 = apply.parameters[0];
                if (apply.constructor == Types.VECTOR && (vecConstant = (Constant)VECTOR_BINDING_CONSTANTS.get((Object)parameter0)) != null) {
                    return new Reduction(new ELiteral(vecConstant), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                Constant constant = (Constant)BINDING_CONSTANTS1.get((Object)apply.constructor);
                if (constant == null) break;
                return new Reduction(new EApplyType(new ELiteral(constant), parameter0), Type.EMPTY_ARRAY, new TPred[]{Types.pred(Types.SERIALIZABLE, parameter0)});
            }
            case 2: {
                Constant constant = (Constant)BINDING_CONSTANTS2.get((Object)apply.constructor);
                if (constant == null) break;
                return new Reduction(Expressions.applyTypes(new ELiteral(constant), apply.parameters), Type.EMPTY_ARRAY, new TPred[]{Types.pred(Types.SERIALIZABLE, apply.parameters[0]), Types.pred(Types.SERIALIZABLE, apply.parameters[1])});
            }
        }
        if (parameter.isGround()) {
            EApplyType bindingGenerator = new EApplyType(new ELiteral(GET_BINDING), parameter);
            EApply bindingExpression = new EApply((Expression)bindingGenerator, (Expression)new ELiteral(new ClassConstant(Types.pred(Types.VEC_COMP, parameter), parameter)));
            return new Reduction(bindingExpression, Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
        }
        return null;
    }
}

