/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.deriving;

import java.util.ArrayList;
import org.simantics.scl.compiler.common.datatypes.Constructor;
import org.simantics.scl.compiler.constants.IntegerConstant;
import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.modules.TypeAlias;
import org.simantics.scl.compiler.elaboration.modules.TypeConstructor;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.deriving.DerivingUtils;
import org.simantics.scl.compiler.internal.deriving.InstanceDeriver;
import org.simantics.scl.compiler.internal.parsing.declarations.DDerivingInstanceAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DInstanceAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DValueAst;
import org.simantics.scl.compiler.internal.parsing.expressions.Expressions;
import org.simantics.scl.compiler.internal.parsing.translation.ProcessedDInstanceAst;
import org.simantics.scl.compiler.internal.parsing.translation.ValueRepository;
import org.simantics.scl.compiler.internal.parsing.types.TVarAst;
import org.simantics.scl.compiler.types.TCon;

class ShowDeriver
implements InstanceDeriver {
    private static final IntegerConstant CONST_10 = new IntegerConstant(10);

    ShowDeriver() {
    }

    @Override
    public void derive(ErrorLog errorLog, Environment environment, ArrayList<ProcessedDInstanceAst> instancesAst, DDerivingInstanceAst der) {
        TCon con;
        if (der.types.length != 1) {
            errorLog.log(der.location, "Invalid number of parameters to " + String.valueOf(der.name));
            return;
        }
        TVarAst headType = DerivingUtils.getHeadType(der.types[0]);
        if (headType == null) {
            errorLog.log(der.types[0].location, "Cannot derive Show instance for the type " + String.valueOf(headType) + ".");
            return;
        }
        try {
            con = Environments.getTypeDescriptorName(environment, headType.name);
        }
        catch (AmbiguousNameException e1) {
            errorLog.log(headType.location, e1.getMessage());
            return;
        }
        if (con == null) {
            errorLog.log(headType.location, "Couldn't resolve " + headType.name);
            return;
        }
        TypeDescriptor tdesc = environment.getTypeDescriptor(con);
        if (tdesc == null) {
            errorLog.log(headType.location, "Didn't find type constructor for " + headType.name);
            return;
        }
        if (tdesc instanceof TypeAlias) {
            errorLog.log(headType.location, "Cannot derive instance for a type alias.");
            return;
        }
        TypeConstructor tcon = (TypeConstructor)tdesc;
        if (tcon.isOpen) {
            errorLog.log(headType.location, "Cannot derive instance for open data types.");
            return;
        }
        DInstanceAst instanceAst = new DInstanceAst(der.location, der.context, der.name, der.types);
        ValueRepository valueDefs = new ValueRepository();
        Constructor[] constructorArray = tcon.constructors;
        int n = tcon.constructors.length;
        int n2 = 0;
        while (n2 < n) {
            DValueAst valueAst;
            Constructor constructor = constructorArray[n2];
            int l = constructor.parameterTypes.length;
            String[] par = new String[l];
            int i = 0;
            while (i < l) {
                par[i] = "v" + i;
                ++i;
            }
            EApply lhs = new EApply((Expression)new EVar("<+"), new EVar("sb"), new EApply((Expression)new EVar(constructor.name.name), Expressions.vars(par)));
            Expression value = new EApply((Expression)new EVar("<<"), new EVar("sb"), new ELiteral(new StringConstant(constructor.name.name)));
            int i2 = 0;
            while (i2 < l) {
                value = new EApply((Expression)new EVar("<<"), value, new ELiteral(new StringConstant(" ")));
                value = new EApply((Expression)new EVar("<+"), value, new EApply((Expression)new EVar("Par"), new ELiteral(CONST_10), new EVar("v" + i2)));
                ++i2;
            }
            try {
                valueAst = new DValueAst(lhs, value);
                valueAst.setLocationDeep(der.location);
                valueDefs.add(valueAst);
            }
            catch (NotPatternException e) {
                errorLog.log(e.getExpression().location, "Not a pattern.");
            }
            lhs = new EApply((Expression)new EVar("precedence"), (Expression)new EApply((Expression)new EVar(constructor.name.name), Expressions.vars(par)));
            value = new ELiteral(new IntegerConstant(l == 0 ? 0 : 20));
            try {
                valueAst = new DValueAst(lhs, value);
                valueAst.setLocationDeep(der.location);
                valueDefs.add(valueAst);
            }
            catch (NotPatternException e) {
                errorLog.log(e.getExpression().location, "Not a pattern.");
            }
            ++n2;
        }
        instancesAst.add(new ProcessedDInstanceAst(instanceAst, valueDefs));
    }
}

