/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.ssa.statements;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.SCLConstant;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAClosure;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAStatement;
import org.simantics.scl.compiler.internal.codegen.ssa.binders.ClosureBinder;
import org.simantics.scl.compiler.internal.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.internal.codegen.utils.CopyContext;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSALambdaLiftingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.internal.codegen.utils.ValRefVisitor;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class LetFunctions
extends SSAStatement
implements ClosureBinder {
    long recursiveGroupLocation;
    SSAClosure firstClosure;

    public LetFunctions() {
    }

    public LetFunctions(SSAClosure closure) {
        this.firstClosure = closure;
        closure.setParent(this);
    }

    @Override
    public void toString(PrintingContext context) {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            context.indentation();
            context.append(closure.getTarget());
            context.append("(" + closure.getTarget().occurrenceCount() + ")");
            context.append(" :: ");
            context.append(closure.getTarget().getType());
            context.append(" = \n");
            context.indent();
            closure.toString(context);
            context.dedent();
            closure = closure.getNext();
        }
    }

    public void addClosure(SSAClosure closure) {
        closure.setParent(this);
        closure.setNext(this.firstClosure);
        if (this.firstClosure != null) {
            this.firstClosure.setPrev(closure);
        }
        this.firstClosure = closure;
    }

    @Override
    public void generateCode(MethodBuilder mb) {
        throw new InternalCompilerError("Functions should be lambda lifted before code generation");
    }

    @Override
    public void validate(SSAValidationContext context) {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            if (!(closure.getTarget() instanceof BoundVar)) {
                throw new InternalCompilerError();
            }
            closure.validate(context);
            closure = closure.getNext();
        }
    }

    @Override
    public void destroy() {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            closure.destroy();
            closure = closure.getNext();
        }
    }

    @Override
    public SSAStatement copy(CopyContext context) {
        LetFunctions result = new LetFunctions();
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            SSAClosure newFunction = closure.copy(context);
            newFunction.setTarget(context.copy(closure.getTarget()));
            result.addClosure(newFunction);
            closure = closure.getNext();
        }
        return result;
    }

    @Override
    public void replace(TVar[] vars, Type[] replacements) {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            ((BoundVar)closure.getTarget()).replace(vars, replacements);
            closure.replace(vars, replacements);
            closure = closure.getNext();
        }
    }

    @Override
    public void addBoundVariablesTo(SSAValidationContext context) {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            context.validBoundVariables.add((Object)((BoundVar)closure.getTarget()));
            closure = closure.getNext();
        }
    }

    @Override
    public SSAClosure getFirstClosure() {
        return this.firstClosure;
    }

    @Override
    public void setFirstClosure(SSAClosure function) {
        this.firstClosure = function;
        if (function == null) {
            this.detach();
        }
    }

    @Override
    public void collectFreeVariables(SSAFunction parentFunction, ArrayList<ValRef> vars) {
        throw new InternalCompilerError("Should not be called for non-lambda-lifted functions.");
    }

    @Override
    public void lambdaLift(SSALambdaLiftingContext context) {
        boolean hasValues = false;
        boolean isRecursive = false;
        THashSet targets = new THashSet();
        ArrayList<ValRef> freeVars = new ArrayList<ValRef>();
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            hasValues |= closure.isValue();
            closure.lambdaLift(context);
            targets.add((Object)((BoundVar)closure.getTarget()));
            closure.collectFreeVariables(freeVars);
            closure = closure.getNext();
        }
        if (!(this.firstClosure instanceof SSAFunction) && this.firstClosure.getNext() == null) {
            THashMap varMap = new THashMap();
            ArrayList<BoundVar> oldVarsList = new ArrayList<BoundVar>(4);
            ArrayList<BoundVar> newVarsList = new ArrayList<BoundVar>(4);
            BoundVar newTarget = null;
            for (ValRef ref : freeVars) {
                BoundVar var = (BoundVar)ref.getBinding();
                if (targets.contains((Object)var)) {
                    if (newTarget == null) {
                        newTarget = new BoundVar(var.getType());
                    }
                    ref.replaceBy(newTarget);
                    continue;
                }
                BoundVar newVar = (BoundVar)varMap.get((Object)var);
                if (newVar == null) {
                    newVar = new BoundVar(var.getType());
                    newVar.setLabel(var.getLabel());
                    oldVarsList.add(var);
                    newVarsList.add(newVar);
                    varMap.put((Object)var, (Object)newVar);
                }
                ref.replaceBy(newVar);
            }
            Constant constant = this.firstClosure.liftClosure(newTarget, newVarsList.toArray(new BoundVar[newVarsList.size()]));
            new LetApply((BoundVar)targets.iterator().next(), Types.PROC, constant.createOccurrence(), ValRef.createOccurrences(oldVarsList)).insertBefore(this);
            this.detach();
            context.addClosure(this.firstClosure);
            return;
        }
        THashSet boundVars = new THashSet();
        ArrayList<BoundVar> boundVarsList = new ArrayList<BoundVar>(4);
        ArrayList<ValRef> newFreeVars = new ArrayList<ValRef>(freeVars.size());
        for (ValRef ref : freeVars) {
            BoundVar var = (BoundVar)ref.getBinding();
            if (targets.contains((Object)var)) {
                isRecursive = true;
                continue;
            }
            if (boundVars.add((Object)var)) {
                boundVarsList.add(var);
            }
            newFreeVars.add(ref);
        }
        BoundVar[] outVars = boundVarsList.toArray(new BoundVar[boundVarsList.size()]);
        freeVars = newFreeVars;
        THashMap varMap = new THashMap();
        THashMap inVarsMap = new THashMap();
        THashMap oldTargets = new THashMap();
        SSAClosure closure2 = this.firstClosure;
        while (closure2 != null) {
            THashMap map = new THashMap(outVars.length);
            BoundVar[] inVars = new BoundVar[outVars.length];
            int i = 0;
            while (i < inVars.length) {
                inVars[i] = new BoundVar(outVars[i].getType());
                map.put((Object)outVars[i], (Object)inVars[i]);
                ++i;
            }
            inVarsMap.put((Object)closure2, (Object)inVars);
            varMap.put((Object)closure2, (Object)map);
            closure2.parametrize(inVars);
            SCLConstant functionConstant = new SCLConstant(context.createName(), closure2.getType());
            context.addConstant(functionConstant);
            oldTargets.put((Object)closure2, (Object)((BoundVar)closure2.getTarget()));
            closure2.setTarget(functionConstant);
            functionConstant.setDefinition((SSAFunction)closure2);
            functionConstant.setPrivate(true);
            closure2 = closure2.getNext();
        }
        closure2 = this.firstClosure;
        while (closure2 != null) {
            BoundVar oldTarget = (BoundVar)oldTargets.get((Object)closure2);
            ValRef[] valRefArray = oldTarget.getOccurences();
            int n = valRefArray.length;
            int functionConstant = 0;
            while (functionConstant < n) {
                ValRef ref = valRefArray[functionConstant];
                SSAFunction parent = ref.getParentFunction();
                Val[] vars = (BoundVar[])inVarsMap.get((Object)parent);
                if (vars == null) {
                    vars = outVars;
                }
                if (vars.length > 0) {
                    ref.replaceByApply(closure2.getTarget(), vars);
                } else {
                    ref.replaceBy(closure2.getTarget());
                }
                ++functionConstant;
            }
            closure2 = closure2.getNext();
        }
        for (ValRef ref : freeVars) {
            BoundVar inVar = (BoundVar)ref.getBinding();
            if (targets.contains((Object)inVar)) continue;
            BoundVar outVar = (BoundVar)((THashMap)varMap.get((Object)ref.getParentFunction())).get((Object)inVar);
            ref.replaceBy(outVar);
        }
        this.detach();
        if (hasValues && isRecursive) {
            context.getErrorLog().log(this.recursiveGroupLocation, "Variables defined recursively must all be functions.");
        }
    }

    @Override
    public void simplify(SSASimplificationContext context) {
        SSAClosure function = this.firstClosure;
        while (function != null) {
            function.simplify(context);
            function = function.getNext();
        }
    }

    public void setRecursiveGroupLocation(long recursiveGroupLocation) {
        this.recursiveGroupLocation = recursiveGroupLocation;
    }

    @Override
    public void forValRefs(ValRefVisitor visitor) {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            closure.forValRefs(visitor);
            closure = closure.getNext();
        }
    }

    @Override
    public void cleanup() {
        SSAClosure closure = this.firstClosure;
        while (closure != null) {
            closure.cleanup();
            closure = closure.getNext();
        }
    }
}

