/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query.compilation;

import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TLongObjectProcedure;
import java.util.ArrayList;
import java.util.Collections;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryConstraint;
import org.simantics.scl.compiler.elaboration.query.compilation.UnsolvableQueryException;

public class DynamicProgrammingOrdering {
    final ConstraintCollectionContext collectionContext;
    int variableCount;
    final QueryConstraint[] constraints;
    TLongObjectHashMap<Entry> entries = new TLongObjectHashMap();

    private DynamicProgrammingOrdering(ConstraintCollectionContext collectionContext, QueryConstraint[] constraints) {
        this.collectionContext = collectionContext;
        this.constraints = constraints;
        int maxVariable = -1;
        QueryConstraint[] queryConstraintArray = constraints;
        int n = constraints.length;
        int n2 = 0;
        while (n2 < n) {
            QueryConstraint constraint = queryConstraintArray[n2];
            int[] nArray = constraint.variables;
            int n3 = constraint.variables.length;
            int n4 = 0;
            while (n4 < n3) {
                int v = nArray[n4];
                maxVariable = Math.max(maxVariable, v);
                ++n4;
            }
            ++n2;
        }
        this.variableCount = maxVariable + 1;
    }

    private void run(long initialVariableBindings) throws UnsolvableQueryException {
        this.entries.put(0L, (Object)new Entry(1.0, 0.0, null, initialVariableBindings));
        int i = 0;
        while (i < this.constraints.length) {
            this.nextEntries();
            ++i;
        }
        Entry entry = (Entry)this.entries.valueCollection().iterator().next();
        if (entry.path != null) {
            entry.path.updateOrder(this.constraints);
        }
        this.updateFinalBoundVariables(initialVariableBindings);
    }

    private void updateFinalBoundVariables(long boundVariables) {
        QueryConstraint[] queryConstraintArray = this.constraints;
        int n = this.constraints.length;
        int n2 = 0;
        while (n2 < n) {
            QueryConstraint constraint = queryConstraintArray[n2];
            constraint.finalBoundVariables = boundVariables;
            boundVariables |= constraint.getVariableMask();
            ++n2;
        }
    }

    private void nextEntries() throws UnsolvableQueryException {
        TLongObjectHashMap<Entry> oldEntries = this.entries;
        this.entries = new TLongObjectHashMap();
        oldEntries.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<Entry>(){

            public boolean execute(long constraintPattern, Entry entry) {
                double branching = entry.branching;
                double cost = entry.cost;
                Path path = entry.path;
                long variables = entry.variables;
                double bestBranching = Double.POSITIVE_INFINITY;
                int bestConstraint = -1;
                int i = 0;
                while (i < DynamicProgrammingOrdering.this.constraints.length) {
                    QueryConstraint constraint;
                    double newBranching;
                    if ((constraintPattern >> i & 1L) == 0L && (newBranching = (constraint = DynamicProgrammingOrdering.this.constraints[i]).getSolutionBranching(variables)) < bestBranching) {
                        bestConstraint = i;
                        bestBranching = newBranching;
                    }
                    ++i;
                }
                if (bestBranching <= 1.0) {
                    QueryConstraint constraint = DynamicProgrammingOrdering.this.constraints[bestConstraint];
                    long newConstraintPattern = constraintPattern | 1L << bestConstraint;
                    double newBranching = constraint.getSolutionBranching(variables) * branching;
                    double newCost = constraint.getSolutionCost(variables) * branching + cost;
                    Entry newEntry = (Entry)DynamicProgrammingOrdering.this.entries.get(newConstraintPattern);
                    if (newEntry == null) {
                        DynamicProgrammingOrdering.this.entries.put(newConstraintPattern, (Object)new Entry(newBranching, newCost, new Path(constraint, path), variables | constraint.getVariableMask()));
                    } else {
                        if (newBranching < newEntry.branching) {
                            newEntry.branching = newBranching;
                        }
                        if (newCost < newEntry.cost) {
                            newEntry.cost = newCost;
                            newEntry.path = new Path(constraint, path);
                        }
                    }
                    return true;
                }
                int i2 = 0;
                while (i2 < DynamicProgrammingOrdering.this.constraints.length) {
                    QueryConstraint constraint;
                    if ((constraintPattern >> i2 & 1L) == 0L && (constraint = DynamicProgrammingOrdering.this.constraints[i2]).canBeSolvedFrom(variables)) {
                        long newConstraintPattern = constraintPattern | 1L << i2;
                        double newBranching = constraint.getSolutionBranching(variables) * branching;
                        double newCost = constraint.getSolutionCost(variables) * branching + cost;
                        Entry newEntry = (Entry)DynamicProgrammingOrdering.this.entries.get(newConstraintPattern);
                        if (newEntry == null) {
                            DynamicProgrammingOrdering.this.entries.put(newConstraintPattern, (Object)new Entry(newBranching, newCost, new Path(constraint, path), variables | constraint.getVariableMask()));
                        } else {
                            if (newBranching < newEntry.branching) {
                                newEntry.branching = newBranching;
                            }
                            if (newCost < newEntry.cost) {
                                newEntry.cost = newCost;
                                newEntry.path = new Path(constraint, path);
                            }
                        }
                    }
                    ++i2;
                }
                return true;
            }
        });
        if (this.entries.isEmpty()) {
            Entry entry = (Entry)oldEntries.valueCollection().iterator().next();
            long variables = entry.variables;
            ArrayList<String> variableNames = new ArrayList<String>();
            int i = 0;
            while (i < this.variableCount) {
                if ((variables >> i & 1L) == 0L) {
                    variableNames.add(this.collectionContext.variables.get(i).getName());
                }
                ++i;
            }
            Collections.sort(variableNames);
            StringBuilder b = new StringBuilder();
            b.append("Unsolved variables: ");
            int i2 = 0;
            while (i2 < variableNames.size()) {
                if (i2 > 0) {
                    b.append(", ");
                }
                b.append((String)variableNames.get(i2));
                ++i2;
            }
            throw new UnsolvableQueryException(b.toString());
        }
    }

    public static void order(ConstraintCollectionContext collectionContext, QueryConstraint[] constraints, long initialVariableBindings) throws UnsolvableQueryException {
        DynamicProgrammingOrdering algorithm = new DynamicProgrammingOrdering(collectionContext, constraints);
        algorithm.run(initialVariableBindings);
    }

    private static class Entry {
        double branching;
        double cost;
        Path path;
        long variables;

        public Entry(double branching, double cost, Path path, long variables) {
            this.branching = branching;
            this.cost = cost;
            this.path = path;
            this.variables = variables;
        }
    }

    private static class Path {
        public final QueryConstraint constraint;
        public final Path prev;

        public Path(QueryConstraint constraint, Path prev) {
            this.constraint = constraint;
            this.prev = prev;
        }

        public void updateOrder(QueryConstraint[] constraints) {
            Path path = this;
            int i = constraints.length - 1;
            while (i >= 0) {
                constraints[i] = path.constraint;
                --i;
                path = path.prev;
            }
        }
    }
}

