/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;
import java.util.Set;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.ELambdaType;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.internal.interpreted.ILambda;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.exceptions.UnificationException;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.MultiFunction;

public class ESimpleLambda
extends Expression {
    public Variable parameter;
    public Expression value;
    public Type effect = Types.NO_EFFECTS;

    public ESimpleLambda(Variable parameter, Expression value) {
        this.parameter = parameter;
        this.value = value;
    }

    public ESimpleLambda(Type effect, Variable parameter, Expression value) {
        this.parameter = parameter;
        this.value = value;
        this.effect = effect;
    }

    public ESimpleLambda(long loc, Variable parameter, Expression value) {
        super(loc);
        this.parameter = parameter;
        this.value = value;
    }

    public ESimpleLambda(long loc, Variable parameter, Type effect, Expression value) {
        super(loc);
        this.parameter = parameter;
        this.value = value;
        this.effect = effect;
    }

    @Override
    public Expression decomposeMatching() {
        this.value = this.value.decomposeMatching();
        return this;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.functionE(Types.canonical(this.parameter.type), this.effect, this.value.getType()));
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        return this.lambdaToVal(context, w);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.value = this.value.simplify(context);
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.value = this.value.resolve(context);
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        Variable newParameter = this.parameter.copy();
        context.varMap.put((Object)this.parameter, (Object)new EVariable(newParameter));
        ESimpleLambda result = new ESimpleLambda(this.getLocation(), newParameter, this.effect.replace(context.tvarMap), this.value.replace(context));
        context.varMap.remove((Object)this.parameter);
        return result;
    }

    public Type getLocalEffect() {
        if (SCLCompilerConfiguration.DEBUG && this.effect == null) {
            throw new InternalCompilerError();
        }
        return this.effect;
    }

    public void setEffect(Type effect) {
        if (effect == null) {
            throw new InternalCompilerError();
        }
        this.effect = effect;
    }

    @Override
    public IExpression toIExpression(ExpressionInterpretationContext context) {
        ArrayList<Variable> parameters = new ArrayList<Variable>(2);
        parameters.add(this.parameter);
        Expression cur = this.value;
        while (true) {
            if (cur instanceof ESimpleLambda) {
                ESimpleLambda lambda = (ESimpleLambda)cur;
                parameters.add(lambda.parameter);
                cur = lambda.value;
                continue;
            }
            if (!(cur instanceof ELambdaType)) break;
            cur = ((ELambdaType)cur).value;
        }
        ExpressionInterpretationContext innerContext = context.createNewContext();
        Set<Variable> freeVariables = cur.getFreeVariables();
        for (Variable parameter : parameters) {
            freeVariables.remove(parameter);
        }
        int i = 0;
        int[] inheritedVariableIds = new int[freeVariables.size()];
        for (Variable var : freeVariables) {
            innerContext.push(var);
            inheritedVariableIds[i++] = context.getVariableId(var);
        }
        for (Variable parameter : parameters) {
            innerContext.push(parameter);
        }
        IExpression body = cur.toIExpression(innerContext);
        return new ILambda(inheritedVariableIds, parameters.size(), innerContext.getMaxVariableId(), body);
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        MultiFunction mfun;
        try {
            mfun = Types.unifyFunction(requiredType, 1);
        }
        catch (UnificationException unificationException) {
            context.getErrorLog().log(this.location, "Required type is <" + String.valueOf(requiredType) + "> which is incompatible with lambda.");
            this.setType(Types.metaVar(Kinds.STAR));
            return this;
        }
        context.pushEffectUpperBound(this.location, mfun.effect);
        this.parameter.setType(mfun.parameterTypes[0]);
        this.value = this.value.checkType(context, mfun.returnType);
        this.effect = context.popEffectUpperBound();
        return this;
    }

    @Override
    public Expression inferType(TypingContext context) {
        this.effect = Types.metaVar(Kinds.EFFECT);
        context.pushEffectUpperBound(this.location, this.effect);
        if (this.parameter.type == null) {
            this.parameter.setType(Types.metaVar(Kinds.STAR));
        }
        this.value = this.value.checkType(context, Types.metaVar(Kinds.STAR));
        context.popEffectUpperBound();
        return this;
    }

    @Override
    public boolean isEffectful() {
        return false;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.value.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public Expression getValue() {
        return this.value;
    }

    public Variable getParameter() {
        return this.parameter;
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public int getSyntacticFunctionArity() {
        return 1 + this.value.getSyntacticFunctionArity();
    }
}

