/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.java.SafeExternalConstant;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class ECHRRuleset
extends Expression
implements SafeExternalConstant,
Externalizable {
    public transient CHRRuleset ruleset;
    public transient String rulesetKey;
    public transient Expression in;

    public ECHRRuleset() {
    }

    public ECHRRuleset(CHRRuleset ruleset, Expression in) {
        this.ruleset = ruleset;
        this.in = in;
    }

    private void ensureRuleset() {
        if (this.ruleset == null) {
            throw new IllegalStateException("Ruleset is null");
        }
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.in.getType());
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        this.ensureRuleset();
        this.ruleset.generateCode(w);
        return this.in.toVal(context, w);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        if (context.currentRuleset != null) {
            context.getErrorLog().log(this.location, "Current version of SCL compiler does not support nested rulesets.");
            return this;
        }
        this.ensureRuleset();
        context.currentRuleset = this.ruleset;
        context.pushFrame();
        context.pushCHRConstraintFrame();
        this.ruleset.resolve(context);
        this.in = this.in.resolve(context);
        context.popCHRConstraintFrame(this.ruleset);
        context.popFrame();
        context.currentRuleset = null;
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.ensureRuleset();
            this.ruleset.setLocationDeep(loc);
            this.in.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression inferType(TypingContext context) {
        this.ensureRuleset();
        this.ruleset.checkType(context);
        this.in = this.in.inferType(context);
        return this;
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        this.ensureRuleset();
        this.ruleset.checkType(context);
        this.in = this.in.checkType(context, requiredType);
        return this;
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.ensureRuleset();
        this.ruleset.simplifyAndCompileIfNeeded(context);
        this.in = this.in.simplify(context);
        return this;
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public IExpression toIExpression(ExpressionInterpretationContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.ruleset.runtimeRulesetClassName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rulesetKey = in.readUTF();
    }
}

