/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.common.names;

import java.io.Serializable;
import java.util.Objects;
import org.simantics.scl.compiler.internal.types.HashConsing;

public final class Name
implements Comparable<Name>,
Serializable {
    public static final Name[] EMPTY_ARRAY = new Name[0];
    public final String module;
    public final String name;
    private static final HashConsing<Name> nameCache = new HashConsing<Name>(){

        @Override
        protected boolean equals(Name a, Name b) {
            return a.name.equals(b.name) && a.module.equals(b.module);
        }

        @Override
        protected int hashCode(Name obj) {
            return obj.module.hashCode() * 31 + obj.name.hashCode();
        }
    };

    private Name(String module, String name) {
        this.module = module;
        this.name = name;
    }

    public String toString() {
        return this.module + "/" + this.name;
    }

    public static Name create(String module, String name) {
        return nameCache.canonical(new Name(module, name));
    }

    public int hashCode() {
        return Objects.hash(this.module, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Name other = (Name)obj;
        return Objects.equals(this.module, other.module) && Objects.equals(this.name, other.name);
    }

    @Override
    public int compareTo(Name other) {
        int result = this.module.compareTo(other.module);
        if (result != 0) {
            return result;
        }
        return this.name.compareTo(other.name);
    }
}

