package org.simantics.scl.compiler.parser.grammar;

import org.simantics.scl.compiler.parser.regexp.Namer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grammar implements Namer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Grammar.class);
    public final Production[] productions;
    public final String[] terminalNames;
    public final String[] nonterminalNames;
    public final int[] initialNonterminals;
    
    public Grammar(Production[] productions, String[] terminalNames,
            String[] nonterminalNames, int[] initialNonterminals) {
        this.productions = productions;
        this.terminalNames = terminalNames;
        this.nonterminalNames = nonterminalNames;
        this.initialNonterminals = initialNonterminals;
    }

    public String getName(int symbolId) {
        if(symbolId >= 0)
            return terminalNames[symbolId];
        else
            return nonterminalNames[~symbolId];
    }
    
    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        for(Production prod : productions) {
            b.append(prod.toString(this));
            b.append("\n");
        }
        /*for(int i=0;i<terminalNames.length;++i)
            b.append(terminalNames[i]).append(' ').append(i).append('\n');*/
        return b.toString();
    }

    public void check() {
        int[] prodCount = new int[nonterminalNames.length];
        for(Production prod : productions)
            ++prodCount[~prod.lhs];
        for(int i=0;i<nonterminalNames.length;++i)
            if(prodCount[i]==0)
                LOGGER.error("Nonterminal " + nonterminalNames[i] + " does not have productions.");
    }
}
