package org.simantics.scl.compiler.parser.generator.table;

import org.simantics.scl.compiler.parser.generator.grammar.AnaGrammar;
import org.simantics.scl.compiler.parser.generator.grammar.Prod;


public class Item implements Comparable<Item> {
    public final int production;
    public final int position;
    public int stackPos;
    
    public Item(int production, int position, int stackPos) {
        this.production = production;
        this.position = position;
        this.stackPos = stackPos;
    }

    public int[] nextSymbols(AnaGrammar grammar) {
        Prod prod = grammar.prods.get(production);
        return prod.rhs.nextStates(position);
    }

    public int nextPosition(AnaGrammar grammar, int symbol) {
        Prod prod = grammar.prods.get(production);
        return prod.rhs.getTransition(position, symbol);
    }
    
    @Override
    public int hashCode() {
        return (production * 31 + position) * 31 + stackPos;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null || getClass() != obj.getClass())
            return false;
        Item other = (Item) obj;
        return production == other.production
                && position == other.position
                && stackPos == other.stackPos;
    }

    @Override
    public int compareTo(Item o) {
        if(production < o.production)
            return -1;
        if(production > o.production)
            return 1;
        if(position < o.position)
            return -1;
        if(position > o.position)
            return 1;
        return 0;        
    }
    
    public String toString(AnaGrammar grammar) {
        Prod prod = grammar.prods.get(production);
        StringBuilder b = new StringBuilder();
        b.append(grammar.nonterminalNames[prod.lhs]);
        b.append(" ::= ");
        /*prod.rhs.toRegexpTo(position).toString(b, grammar, 0);
        b.append(" . ");
        prod.rhs.toRegexpFrom(position).toString(b, grammar, 0);*/
        prod.rhs.toPositionalRegexp(position).toString(b, grammar, 0);
        if(stackPos >= 0)
            b.append(" (stack ").append(stackPos).append(')');
        /*for(int i=0;i<position;++i)
            b.append(' ').append(grammar.getName(prod.rhs[i]));
        b.append(" *");
        for(int i=position;i<prod.rhs.length;++i)
            b.append(' ').append(grammar.getName(prod.rhs[i]));*/
        return b.toString();
    }

    public boolean isReducible(AnaGrammar grammar) {
        return grammar.prods.get(production).rhs.getAccepts(position);
    }

}
