package org.simantics.scl.compiler.module.coverage;

import java.io.PrintStream;
import java.util.Arrays;

import gnu.trove.map.hash.THashMap;

public class CombinedCoverage extends AbstractCoverage {
    public final THashMap<String, ModuleCoverage> moduleCoverages;

    public final int totalFunctionCount;
    public final int coveredFunctionCount;
    public final double functionCoverage;
    
    public CombinedCoverage(THashMap<String, ModuleCoverage> moduleCoverages,
            int totalCodeSize, int coveredCodeSize,
            int totalFunctionCount, int coveredFunctionCount) {
        super("Total coverage of " + moduleCoverages.size() +  " modules", totalCodeSize, coveredCodeSize);
        this.moduleCoverages = moduleCoverages;
        this.totalFunctionCount = totalFunctionCount;
        this.coveredFunctionCount = coveredFunctionCount;
        this.functionCoverage = CoverageUtils.safeDiv(coveredFunctionCount, totalFunctionCount);
    }
    
    public void print(PrintStream s) {
        s.println("Code coverage: " + toPercent(getCoverage()) +
                " (" + getCoveredCodeSize() + " / " + getTotalCodeSize() + ")"); 
        s.println("Function coverage: " + toPercent(functionCoverage) +
                " (" + coveredFunctionCount + " / " + totalFunctionCount + ")");
        String[] moduleNames = moduleCoverages.keySet().toArray(new String[moduleCoverages.size()]);
        Arrays.sort(moduleNames);
        for(String functionName : moduleNames) {
            ModuleCoverage mCov = moduleCoverages.get(functionName);
            s.println("    " + functionName + ": " + toPercent(mCov.getCoverage()) +
                    " (" + mCov.getCoveredCodeSize() + " / " + mCov.getTotalCodeSize() + ")");
        }   
    }

}
