package org.simantics.scl.compiler.module;

public class ModuleUtils {
    public static boolean isRelativeImport(ImportDeclaration relativeImport) {
        return relativeImport.moduleName.startsWith(".");
    }

    public static String resolveAbsolutePath(String moduleName, String relativeModuleName) throws InvalidModulePathException {
        if (relativeModuleName.startsWith(".")) {
            String originalRelativeModuleName = relativeModuleName;
            int p = moduleName.lastIndexOf('/');
            String parentPackage = p < 0 ? "" : moduleName.substring(0, p);
            while(relativeModuleName.startsWith(".")) {
                if(relativeModuleName.equals(".")) {
                    return parentPackage;
                }
                else if(relativeModuleName.startsWith("./")) {
                    relativeModuleName = relativeModuleName.substring(2);
                }
                else if(relativeModuleName.startsWith("../")) {
                    relativeModuleName = relativeModuleName.substring(3);
                    if(parentPackage.isEmpty()) {
                        throw new InvalidModulePathException("Couldn't resolve the relative module name " + originalRelativeModuleName + " when the current module name is " + moduleName + ".");
                    }
                    p = parentPackage.lastIndexOf('/');
                    parentPackage = p < 0 ? "" : parentPackage.substring(0, p);
                }
                else {
                    throw new InvalidModulePathException("Couldn't resolve the relative module name " + originalRelativeModuleName + ". It has an invalid syntax.");
                }
            }
            return parentPackage + "/" + relativeModuleName;
        } else {
            return relativeModuleName;
        }
    }
}
