package org.simantics.scl.compiler.internal.parsing;

import org.simantics.scl.compiler.errors.Locations;


public class Token extends Symbol {
    public static final Token[] EMPTY_ARRAY = new Token[0];
    
    public final String text;
    public final int id;
    
    public Token(int type, long location, String text) {
        this.id = type;
        this.location = location;
        this.text = text;
    }
    
    public Token(int type, int begin, int end, String text) {
        this(type, Locations.location(begin, end), text);
    }

    @Override
    public String toString() {
        return text;
    }
}
