package org.simantics.scl.compiler.internal.interpreted;

import java.util.Arrays;
import java.util.Objects;

import org.simantics.scl.runtime.function.Function;

public class IApply implements IExpression {
    private final IExpression function;
    private final IExpression[] parameters;
    
    public IApply(IExpression function, IExpression[] parameters) {
        if(function instanceof IApply) {
            IApply apply = (IApply)function;
            this.function = apply.function;
            this.parameters = new IExpression[apply.parameters.length + parameters.length];
            System.arraycopy(apply.parameters, 0, this.parameters, 0, apply.parameters.length);
            System.arraycopy(parameters, 0, this.parameters, apply.parameters.length, parameters.length);
        }
        else {
            this.function = function;
            this.parameters = parameters;
        }
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Object execute(Object[] variableBindings) {
        Object[] parameterValues = new Object[parameters.length];
        for(int i=0;i<parameters.length;++i)
            parameterValues[i] = parameters[i].execute(variableBindings);
        return ((Function)function.execute(variableBindings)).applyArray(parameterValues);
    }
    
    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('(');
        b.append(function);
        for(IExpression parameter : parameters) {
            b.append(' ');
            b.append(parameter);
        }
        b.append(')');
        return b.toString();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(parameters);
        result = prime * result + Objects.hash(function);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        IApply other = (IApply) obj;
        return Objects.equals(function, other.function) && Arrays.equals(parameters, other.parameters);
    }

}
