package org.simantics.scl.compiler.internal.elaboration.subsumption;

import java.util.ArrayList;


public class VUnion {
    Var low;
    int con;
    ArrayList<Var> vars;
    
    public VUnion(int con, ArrayList<Var> vars) {
        this.con = con;
        this.vars = vars;        
    }
    
    public void removeVar(Var var) {
        if(vars.remove(var)) {
            var.complexLowerBounds.remove(this);
            var.markDirty();
        }
    }
    
    public void addVar(Var var) {
        if(!vars.contains(var)) {
            vars.add(var);
            var.complexLowerBounds.add(this);
            var.markDirty();
        }
    }
    
    public void makeLowerBound(int low) {
        con |= ~low;
        if(vars.size() == 1)
            vars.get(0).addLowerBound(~con);
        else
            for(Var v : vars)
                v.complexLowerBounds.add(this);
    }
    
    public int getUpperApprox() {
        int cur = con;
        for(Var v : vars)
            cur |= v.upperApprox;
        return cur;
    }
    
    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        if(con > 0) {
            b.append(con);
            first = false;
        }
        for(Var v : vars) {
            if(first)
                first = false;
            else
                b.append(" + ");
            b.append(v.name);
        }
        return b.toString();
    }
}
