package org.simantics.scl.compiler.internal.codegen.utils;

import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class SSAUtils {

    public static boolean representSameValue(Val a, ValRef b) {
        if(b.getTypeParameters().length > 0)
            return false;
        return representSameValue(a, b.getBinding());
    }
    
    public static boolean representSameValue(Val a, Val b) {
        if(a == b)
            return true;
        Type aT = a.getType();
        Type bT = b.getType();
        if(!Types.equals(aT, bT))
            return false;
        return isSingletonType(aT);
    }

    public static boolean isSingletonType(Type type) {
        type = Types.canonical(type);
        return type == Types.UNIT || type == Types.PUNIT;
    }
    
}
