package org.simantics.scl.compiler.elaboration.expressions.visitors;

import org.simantics.scl.compiler.elaboration.expressions.EAsPattern;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;

public class ForVariablesUsesVisitor extends StandardExpressionVisitor {
    VariableProcedure procedure;
    
    public ForVariablesUsesVisitor(VariableProcedure procedure) {
        this.procedure = procedure;
    }
    
    @Override
    public void visit(EVariable expression) {
        if(expression.variable != null)
            procedure.execute(expression.location, expression.variable);
    }
    @Override
    public void visit(EAsPattern expression) {
        expression.pattern.accept(this);
        procedure.execute(expression.eVar.location, expression.var);
    }
}
