package org.simantics.scl.compiler.elaboration.expressions.accessor;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.types.Types;

public class ExpressionAccessor extends FieldAccessor {
    public Expression fieldName;

    public ExpressionAccessor(char accessSeparator, Expression fieldName) {
        super(accessSeparator);
        this.fieldName = fieldName;
    }
    
    @Override
    public void resolve(TranslationContext context) {
        fieldName = fieldName.resolve(context);
    }
    
    @Override
    public void simplify(SimplificationContext context) {
        fieldName = fieldName.simplify(context);
    }
    
    @Override
    public void checkType(TypingContext context) {
        fieldName = fieldName.checkType(context, Types.STRING);
    }

    @Override
    public Expression asExpression() {
        return fieldName;
    }

    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            fieldName.setLocationDeep(loc);
        }
    }
    
    @Override
    public void accept(FieldAccessorVisitor visitor) {
        visitor.visit(this);
    }
}
