package org.simantics.scl.compiler.elaboration.chr.planning;

public abstract class PrePlanItem {
    int queuePos;
    /* Primary priorities:
     *     0 = check
     *     1 = functional calculation
     *     2 = almost completely bound relation
     *     3 = completely inbound relation
     */
    public double primaryPriority = Double.POSITIVE_INFINITY;
    public int secondaryPriority;
    public long location;
        
    public PrePlanItem(int secondaryPriority) {
        this.secondaryPriority = secondaryPriority;
    }

    public int compare(PrePlanItem other) {
        if(primaryPriority < other.primaryPriority)
            return -1;
        if(primaryPriority > other.primaryPriority)
            return 1;
        return Integer.compare(secondaryPriority, other.secondaryPriority);    
    }

    public abstract void initializeListeners(QueryPlanningContext context);
    public abstract void variableSolved(QueryPlanningContext context, int variableId);

    public abstract void generate(QueryPlanningContext context);
}
