package org.simantics.scl.compiler.constants;

import org.objectweb.asm.Label;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.runtime.tuple.Tuple0;

public class NoRepConstant extends Constant {
    public static final NoRepConstant PUNIT = new NoRepConstant(Types.PUNIT);
    public static final NoRepConstant UNIT = new NoRepConstant(Types.UNIT);
    
    public NoRepConstant(Type type) {
        super(type);
    }
    
    public void push(MethodBuilder mb) {
    }
    

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success,
            Label failure) {
        mb.jump(success);
    }
    
    public int constructorTag() {
        return 0;
    }
    
    @Override
    public String toString() {
        return "()";
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return Tuple0.INSTANCE;
    }
}
