package org.simantics.scl.compiler.common.names;

import java.io.Serializable;
import java.util.Objects;

import org.simantics.scl.compiler.internal.types.HashConsing;

public final class Name implements Comparable<Name>, Serializable {
    public static final Name[] EMPTY_ARRAY = new Name[0];
    
    public final String module;
    public final String name;
    
    private Name(String module, String name) {
        this.module = module;
        this.name = name;
    }
    
    private static final HashConsing<Name> nameCache = 
            new HashConsing<Name>() {
        protected boolean equals(Name a, Name b) {
            return a.name.equals(b.name) && a.module.equals(b.module);
        }

        protected int hashCode(Name obj) {
            return obj.module.hashCode()*31 + obj.name.hashCode();
        }
    };
    
    public String toString() {
        return module + "/" + name;
    }
    
    public static Name create(String module, String name) {
        return nameCache.canonical(new Name(module, name));
    }

	@Override
	public int hashCode() {
		return Objects.hash(module, name);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Name other = (Name) obj;
		return Objects.equals(module, other.module) && Objects.equals(name, other.name);
	}

	@Override
	public int compareTo(Name other) {
		int result = module.compareTo(other.module);
		if(result != 0)
			return result;
		return name.compareTo(other.name);
	}
    
}
