/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.events.adapter;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.IEventQueue;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.adapter.AbstractEventAdapter;

public class AWTRemoteEventAdapter
extends AbstractEventAdapter
implements AWTEventListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    public static final int MOUSE_ID = 0;
    private long[] pressTime = new long[5];
    int buttonStatus = 0;

    public AWTRemoteEventAdapter(Object sender, IEventHandler delegator) {
        super(sender, delegator);
    }

    public AWTRemoteEventAdapter(Object sender, IEventQueue queue) {
        super(sender, queue);
    }

    private Point2D getControlPosition(MouseEvent e) {
        return new Point2D.Double(e.getX(), e.getY());
    }

    private Point2D getScreenPosition(MouseEvent e) {
        Point p = e.getLocationOnScreen();
        return new Point2D.Double(p.x, p.y);
    }

    private int getMouseButton(MouseEvent e) {
        int awtMouseButton = e.getButton();
        if (awtMouseButton == 1) {
            return 1;
        }
        if (awtMouseButton == 2) {
            return 3;
        }
        if (awtMouseButton == 3) {
            return 2;
        }
        return awtMouseButton;
    }

    private static int getStateMask(MouseEvent e) {
        int modifiers = e.getModifiersEx();
        int stateMask = 0;
        if ((modifiers & 0x80) != 0) {
            stateMask |= 0x80;
        }
        if ((modifiers & 0x200) != 0) {
            stateMask |= 0x200;
        }
        if ((modifiers & 0x2000) != 0) {
            stateMask |= 0x2000;
        }
        if ((modifiers & 0x40) != 0) {
            stateMask |= 0x40;
        }
        return stateMask;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.buttonStatus = 0;
        MouseEvent.MouseEnterEvent me = new MouseEvent.MouseEnterEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTRemoteEventAdapter.getStateMask(e), this.getControlPosition(e), this.getScreenPosition(e));
        this.handleEvent(me);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        MouseEvent.MouseExitEvent me = new MouseEvent.MouseExitEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTRemoteEventAdapter.getStateMask(e), this.getControlPosition(e), this.getScreenPosition(e));
        this.handleEvent(me);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int mouseButton = this.getMouseButton(e);
        if (mouseButton <= this.pressTime.length) {
            this.pressTime[mouseButton - 1] = e.getWhen();
        }
        this.buttonStatus |= 1 << mouseButton - 1;
        this.handleEvent(new MouseEvent.MouseButtonPressedEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTRemoteEventAdapter.getStateMask(e), mouseButton, this.getControlPosition(e), this.getScreenPosition(e)));
        if (e.getClickCount() == 2) {
            this.handleEvent(new MouseEvent.MouseDoubleClickedEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTRemoteEventAdapter.getStateMask(e), mouseButton, this.getControlPosition(e), this.getScreenPosition(e)));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int mouseButton = this.getMouseButton(e);
        long holdTime = Long.MAX_VALUE;
        if (mouseButton <= this.pressTime.length) {
            holdTime = e.getWhen() - this.pressTime[mouseButton - 1];
        }
        this.buttonStatus &= ~(1 << mouseButton - 1);
        MouseEvent.MouseButtonReleasedEvent me = new MouseEvent.MouseButtonReleasedEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTRemoteEventAdapter.getStateMask(e), mouseButton, holdTime, this.getControlPosition(e), this.getScreenPosition(e));
        this.handleEvent(me);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        MouseEvent.MouseMovedEvent me = new MouseEvent.MouseMovedEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTRemoteEventAdapter.getStateMask(e), this.getControlPosition(e), this.getScreenPosition(e));
        this.handleEvent(me);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        MouseEvent.MouseMovedEvent me = new MouseEvent.MouseMovedEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTRemoteEventAdapter.getStateMask(e), this.getControlPosition(e), this.getScreenPosition(e));
        this.handleEvent(me);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int wheelRotation = 0;
        wheelRotation = e.getScrollType() == 0 ? -e.getUnitsToScroll() : -e.getWheelRotation();
        this.handleEvent(new MouseEvent.MouseWheelMovedEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTRemoteEventAdapter.getStateMask(e), this.getControlPosition(e), this.getScreenPosition(e), e.getScrollType(), e.getScrollAmount(), wheelRotation));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.handleEvent(new KeyEvent.KeyPressedEvent(this.sender, e.getWhen(), e.getKeyChar(), e.getKeyCode(), e.getModifiers()));
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.handleEvent(new KeyEvent.KeyReleasedEvent(this.sender, e.getWhen(), e.getKeyChar(), e.getKeyCode(), e.getModifiers()));
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getID() == 401) {
            this.keyPressed((KeyEvent)event);
        }
        if (event.getID() == 402) {
            this.keyReleased((KeyEvent)event);
        }
        if (event.getID() == 400) {
            this.keyTyped((KeyEvent)event);
        }
        if (event.getID() == 503) {
            this.mouseMoved((MouseEvent)event);
        }
        if (event.getID() == 506) {
            this.mouseDragged((MouseEvent)event);
        }
        if (event.getID() == 501) {
            this.mousePressed((MouseEvent)event);
        }
        if (event.getID() == 502) {
            this.mouseReleased((MouseEvent)event);
        }
        if (event.getID() == 500) {
            this.mouseClicked((MouseEvent)event);
        }
        if (event.getID() == 507) {
            this.mouseWheelMoved((MouseWheelEvent)event);
        }
        if (event.getID() == 504) {
            this.mouseEntered((MouseEvent)event);
        }
        if (event.getID() == 505) {
            this.mouseExited((MouseEvent)event);
        }
    }
}

