/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.utils.variable;

/**
 * A container for a single dynamic-enabled float variable of a scene graph
 * node. Dynamic-enabled means a variable that potentially has two values: one
 * static (~ default) and one dynamic. If the dynamic part has a non-null value
 * it should always be used instead of the static value. Use
 * {@link #getActiveValue()} to get the current variable value to follow this
 * policy in your client code.
 * 
 * <p>
 * Variables generally determine the way a node gets rendered.
 * 
 * @author Tuukka Lehtonen
 */
public class DynamicObject<T> extends DynamicVariable<T> {

    private T value;

    public static <T> DynamicObject<T> make(T initialValue) {
        return new DynamicObject<T>(initialValue);
    }

    public DynamicObject(T initialValue) {
        this.value = initialValue;
    }

    public T getValue() {
        return value;
    }

    public T getActiveValue() {
        return dynamicValue != null ? dynamicValue : value;
    }

    /**
     * Sets the static value of the variable.
     * 
     * @param value new static value
     */
    public void setValue(T value) {
        this.value = value;
    }

    public boolean hasDynamicValue() {
        return dynamicValue != null && getValue() != getActiveValue();
    }

}
