/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.events;

import org.simantics.scenegraph.g2d.events.IEventQueue.EventCoalescer;
import org.simantics.scenegraph.g2d.events.MouseEvent.MouseMovedEvent;

/**
 * Coalescales mouse events
 * 
 * @author Toni Kalajainen
 */
public class MouseEventCoalescer implements EventCoalescer {

    public static final MouseEventCoalescer INSTANCE = new MouseEventCoalescer();

    @Override
    public Event coalesce(Event apriori, Event aposterior) {
        if (!(apriori instanceof MouseMovedEvent)) return null;
        if (!(aposterior instanceof MouseMovedEvent)) return null;
        MouseMovedEvent m1 = (MouseMovedEvent) apriori;
        MouseMovedEvent m2 = (MouseMovedEvent) aposterior;
        if (m1.mouseId!=m2.mouseId) return null;
        return aposterior;
    }

}
