/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph;

/**
 * Used for signalling errors in scene graph node instantiation in
 * {@link ParentNode}.
 * 
 * @author Tuukka Lehtonen
 */
public class NodeException extends RuntimeException {

    private static final long serialVersionUID = 235239332297954197L;

    public NodeException() {
        super();
    }

    public NodeException(String message, Throwable cause) {
        super(message, cause);
    }

    public NodeException(String message) {
        super(message);
    }

    public NodeException(Throwable cause) {
        super(cause);
    }

}
