/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph;

/**
 * A bijective mapping service between unique String ID's and scene graph nodes
 * ({@link INode}).
 * 
 * @author Tuukka Lehtonen
 */
public interface ILookupService {

    /**
     * Associates the specified node with the specified ID. If the specified ID
     * is already associated the previous association will be overwritten with
     * the new one and the previously associated node is returned.
     * 
     * @param id the id to map to the specified node
     * @param node node to map to specified id
     * @return the node previously associated with the specified ID or
     *         <code>null</code> if the specified ID no previous association
     * @throws NullPointerException if either argument is <code>null</code>
     */
    INode map(String id, INode node);

    /**
     * Removes possibly existing ID <=> node mapping from the lookup service.
     * 
     * @param id the id to unmap
     * @return the unmapped INode if successful, <code>null</code> otherwise
     */
    INode unmap(String id);

    /**
     * Removes possibly existing node <=> ID mapping from the lookup service.
     * 
     * @param node the node to unmap
     * @return the unmapped ID if successful, <code>null</code> otherwise
     */
    String unmap(INode node);

    /**
     * Get the node mapped to the specified ID.
     * 
     * @param id identifier of the node to look for
     * @return node mapped with specified id or <code>null</code> if no mapping
     *         exists
     */
    INode lookupNode(String id);

    /**
     * Get the mapping ID for the specified node.
     * 
     * @param node node to get mapping ID for
     * @return mapping ID of the node or <code>null</code> if node is not mapped
     */
    String lookupId(INode node);

}
