/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.features.registry;

import java.util.Collection;
import java.util.HashSet;

public class GroupReference
implements Comparable<GroupReference> {
    public static final GroupReference OMNIPRESENT = new GroupReference("omnipresent");
    private final String id;
    private final String version;

    public GroupReference withoutVersion() {
        return this.version == null ? this : new GroupReference(this.id);
    }

    public static Collection<GroupReference> stripVersions(Collection<GroupReference> refs) {
        HashSet<GroupReference> result = new HashSet<GroupReference>();
        for (GroupReference ref : refs) {
            result.add(ref.withoutVersion());
        }
        return result;
    }

    public static GroupReference parse(String ref) {
        int slash = ref.indexOf(47);
        if (slash >= 0) {
            String id = ref.substring(0, slash);
            String version = ref.substring(slash + 1);
            return new GroupReference(id, version);
        }
        return new GroupReference(ref);
    }

    public GroupReference(String id) {
        this(id, null);
    }

    public GroupReference(String id, String version) {
        if (id == null) {
            throw new NullPointerException("null feature bundle id");
        }
        this.id = id;
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.version != null ? this.id + "/" + this.version : this.id;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupReference other = (GroupReference)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public boolean idEquals(GroupReference other) {
        return this.id.equals(other.id);
    }

    public boolean includes(GroupReference request) {
        if (!this.id.equals(request.id)) {
            return false;
        }
        if (this.version == null) {
            return true;
        }
        return true;
    }

    @Override
    public int compareTo(GroupReference o) {
        int idDelta = this.id.compareTo(o.id);
        if (idDelta != 0) {
            return idDelta;
        }
        return 0;
    }
}

