/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.features;

import java.util.ArrayList;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.project.IProject;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.IProjectFeature;
import org.simantics.utils.datastructures.hints.IHintContext;

public abstract class AbstractProjectFeature
implements IProjectFeature {
    private IProject project;

    protected void assertProject() {
        if (this.project == null) {
            throw new IllegalStateException("project element is null");
        }
    }

    @Override
    public IProject getProjectElement() {
        return this.project;
    }

    public IProject getProject() {
        this.assertProject();
        return this.project;
    }

    public IProject peekProject() {
        return this.project;
    }

    protected Session getSession() {
        IProject p = this.getProject();
        Session s = p.getSession();
        if (s == null) {
            throw new IllegalStateException("project not attached to a database session");
        }
        return s;
    }

    protected Session peekSession() {
        IProject p = this.peekProject();
        if (p == null) {
            return null;
        }
        return p.getSession();
    }

    protected RequestProcessor getGraphRequestProcessor() {
        IProject p = this.peekProject();
        if (p == null) {
            return null;
        }
        Session s = p.getSession();
        Session mgrp = null;
        return mgrp != null ? mgrp : s;
    }

    @Override
    public void setProjectElement(IProject project) {
        this.project = project;
    }

    public void onActivated(ReadGraph graph, IProject project) throws DatabaseException {
    }

    @Override
    public void configure() throws ProjectException {
        try {
            this.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    AbstractProjectFeature.this.onActivated(graph, AbstractProjectFeature.this.getProject());
                }
            });
        }
        catch (DatabaseException e) {
            throw new ProjectException(e);
        }
    }

    @Override
    public void deconfigure() throws ProjectException {
    }

    protected <T> void addToCollectionHint(IHintContext.Key key, T ... ts) {
        ArrayList<T> c = (ArrayList<T>)this.getProjectElement().getHint(key);
        if (c == null) {
            c = new ArrayList<T>();
            this.getProjectElement().setHint(key, c);
        }
        T[] TArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            c.add(t);
            ++n2;
        }
    }
}

