/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.simantics.db.ServerEx;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.project.management.BundlePool;
import org.simantics.project.management.DatabaseSpec;
import org.simantics.project.management.FeatureSpec;
import org.simantics.project.management.ProjectSpec;

public class DatabaseAgent {
    ServerEx server;
    BundlePool bundlePool;

    public DatabaseAgent(ServerEx server, BundlePool bundlePool) {
        this.server = server;
        this.bundlePool = bundlePool;
    }

    public DatabaseSpec getSpecification() throws DatabaseException {
        Properties props = new Properties();
        Session session = this.server.createSession(props);
        try {
            DatabaseSpec databaseSpec = (DatabaseSpec)session.syncRequest(DatabaseSpec.QUERY);
            return databaseSpec;
        }
        finally {
            ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
        }
    }

    public void perform(DatabaseSpec spec) throws DatabaseException {
    }

    public List<Problem> validate(DatabaseSpec spec) {
        ArrayList<Problem> result = new ArrayList<Problem>();
        for (ProjectSpec ps : spec.projects) {
            for (FeatureSpec fs : ps.features) {
                VersionedId.parse((String)fs.versionedId);
            }
        }
        return result;
    }

    static class OntologyVersionConflict {
        OntologyVersionConflict() {
        }
    }

    static class Problem {
        public int severity;
        public String msg;

        Problem() {
        }
    }
}

