/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.management;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

/**
 * Workspace management utils
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class WorkspaceUtil {

	/**
	 * Write project properties 
	 * 
	 * Project URI is in a text file simantics.cfg 
	 * 
	 * @param propertyFile
	 * @param props
	 * @throws IOException 
	 */
	public static void writeProperties(File propertyFile, Properties props) throws IOException {
	    FileWriter fw = null;
	    try {
	    	fw = new FileWriter( propertyFile );
	    	props.store(fw, "Project configuration");
	    } finally {
	    	if (fw!=null) fw.close();
	    }				
	}
	
	/**
	 * Read project properties in a workspace
	 * 
	 * @param workspace
	 * @return
	 * @throws IOException
	 */
	public static Properties readProperties(File propertyFile) throws IOException {
	    FileReader fr = null;
	    try {
	    	fr = new FileReader(propertyFile);	    	
			Properties props = new Properties();
		    props.load(fr);
			return props;
	    } finally {
	    	if (fr!=null) fr.close();
	    }
		
	}

	
}

