/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.features.registry;

/**
 * @author Tuukka Lehtonen
 */
public class ProjectFeatureReference {

    public final String  id;
    public final boolean optional;

    public ProjectFeatureReference(String id, boolean optional) {
        if (id == null)
            throw new NullPointerException("null project feature id");
        this.id = id;
        this.optional = optional;
    }

    @Override
    public String toString() {
        return id + (optional ? "[optional]" : "");
    }

    @Override
    public int hashCode() {
        return id.hashCode() * 31 + (optional ? 1 : 0);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ProjectFeatureReference other = (ProjectFeatureReference) obj;
        return id.equals(other.id) && optional == other.optional;
    }

}
