/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.management;

import java.util.ArrayList;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;

/**
 * A description of database 
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class DatabaseSpec {

	// Installed Ontologies
	public List<OntologySpec> ontologies = new ArrayList<OntologySpec>();
	
	// Installed Projects	
	public List<ProjectSpec> projects = new ArrayList<ProjectSpec>();	
	
	
	/** A query that reads database spec, projects ordered by URI, ontologies ordered by versionedId */
	static Read<DatabaseSpec> QUERY = new Read<DatabaseSpec>() {
		@Override
		public DatabaseSpec perform(ReadGraph g) throws DatabaseException {
			DatabaseSpec spec = new DatabaseSpec();
			spec.projects = g.syncRequest( ProjectSpec.QUERY );
			spec.ontologies = g.syncRequest( OntologySpec.QUERY );
			return spec;
		}
	};
	
	
}

