/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.management;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.eclipse.equinox.p2.metadata.VersionedId;
import org.simantics.db.ServerEx;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.LifecycleSupport;

/**
 * Database agent installs ontologies and   
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class DatabaseAgent {

	ServerEx server;
	BundlePool bundlePool;
	
	/**
	 * Create a new agent.
	 * 
	 * @param server
	 * @param bundlePool
	 * @throws DatabaseException
	 */
	public DatabaseAgent(ServerEx server, BundlePool bundlePool) {
		this.server = server;
		this.bundlePool = bundlePool;
	}
	
	/**
	 * Get a snapshot of database current profile
	 * 
	 * @return database specification
	 * @throws DatabaseException
	 */
	public DatabaseSpec getSpecification() throws DatabaseException {
		// Create session
		Properties props = new Properties();
		Session session = server.createSession(props);
		try {
			return session.syncRequest( DatabaseSpec.QUERY );
		} finally {
			// Close session
			session.getService(LifecycleSupport.class).close();
		}
	}
	
	/**
	 * Perform install operation to 
	 * @param spec
	 * @throws DatabaseException
	 */
	public void perform(DatabaseSpec spec) throws DatabaseException {

		// 1. Validate Spec
		
		
	}
	
	public List<Problem> validate(DatabaseSpec spec) {
		ArrayList<Problem> result = new ArrayList<Problem>();
		
		// 1. Ontology exists for all features
		for (ProjectSpec ps : spec.projects) {
			for (FeatureSpec fs : ps.features) {
				/*IVersionedId vid =*/ VersionedId.parse(fs.versionedId);
				// Now use BundlePool to find out ontologies
//				bundlePool.getMetadataRepository()
			}
		}
		
		return result;
	}

	
	static class Problem {
		// Cost of the problem. 0-100
		public int severity;
		public String msg;
	}

	static class OntologyVersionConflict {
		
	}
	
}

