/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.internal;

import java.util.Collection;
import java.util.Collections;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.simantics.project.features.IProjectFeature;
import org.simantics.project.features.registry.GroupReference;
import org.simantics.project.features.registry.IProjectFeatureExtension;
import org.simantics.project.features.registry.InjectedDependency;
import org.simantics.project.features.registry.ProjectFeatureReference;

/**
 * @author Tuukka Lehtonen
 */
class ProjectFeatureExtension implements IProjectFeatureExtension {

    // For access to createExecutableExtension(String).
    private final IConfigurationElement configurationElement;

    private final String id;
    private final String label;
    private final String description;
    private final boolean published;

    private final Collection<ProjectFeatureReference> requires;
    private final Collection<GroupReference> installGroups;
    private final Collection<InjectedDependency> injections;

    public ProjectFeatureExtension(IConfigurationElement ce, String id, String label, String description,
            boolean published, Collection<ProjectFeatureReference> requires, Collection<InjectedDependency> injections,
            Collection<GroupReference> installGroups) {
        this.configurationElement = ce;
        this.id = id;
        this.label = label;
        this.description = description;
        this.published = published;
        this.requires = Collections.unmodifiableCollection(requires);
        this.injections = Collections.unmodifiableCollection(injections);
        this.installGroups = Collections.unmodifiableCollection(installGroups);
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public String getLabel() {
        return label;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public boolean isPublished() {
        return published;
    }

    @Override
    public Collection<ProjectFeatureReference> requires() {
        return requires;
    }

    public Collection<InjectedDependency> injections() {
        return injections;
    }

    @Override
    public Collection<GroupReference> installGroups() {
        return installGroups;
    }

    @Override
    public IProjectFeature newInstance() throws CoreException {
        return (IProjectFeature) configurationElement.createExecutableExtension("class");
    }

    @Override
    public String toString() {
        return super.toString() + " [id=" + id + ", label=" + label + ", description=" + description + ", published=" + published + ", requires=" + requires + ", injections=" + injections + ", usedWithGroups=" + installGroups + "]";
    }

}