/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.features.registry;

/**
 * API for a project feature extension registry.
 * 
 * @author Tuukka Lehtonen
 */
public interface IProjectFeatureRegistry {

    /**
     * @return all <code>org.simantics.project.feature</code> extensions loaded by the platform
     */
    IProjectFeatureExtension[] getExtensions();

    /**
     * @param id
     * @return <code>null</code> if extension with specified id not found
     */
    IProjectFeatureExtension getExtensionById(String id);

}