/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.features.registry;

import java.util.Collection;

import org.eclipse.core.runtime.CoreException;
import org.simantics.project.features.IProjectFeature;

/**
 * @author Tuukka Lehtonen
 */
public interface IProjectFeatureExtension {

    /**
     * @return id of this extension
     */
    String getId();

    /**
     * @return label of this extension
     */
    String getLabel();

    /**
     * @return description of this extension
     */
    String getDescription();

    /**
     * Informs whether this project feature should be published to users in UI's
     * that visualize user selectable project features in some manner.
     * 
     * For example top level project features should always be published in
     * order to give Simantics Project Manager users the possibility to select
     * the feature to be used in their project.
     * 
     * @return <code>true</code> if the extension is published
     */
    boolean isPublished();

    /**
     * @return
     */
    Collection<ProjectFeatureReference> requires();

    /**
     * @return
     */
    Collection<InjectedDependency> injections();

    /**
     * @return
     */
    Collection<GroupReference> installGroups();

    /**
     * @return a new instance of the IProjectFeature described by this extension
     */
    IProjectFeature newInstance() throws CoreException;

}
