/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project;

import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * @author Tuukka Lehtonen
 */
public interface ProjectKeys {

    /**
     * A key for storing an IProject in an IHintContext. This is used with
     * ISessionContext.
     */
    Key KEY_PROJECT                       = new KeyOf(IProject.class, "PROJECT");

    /**
     * A string describing the default workbench perspective ID for a project.
     */
    Key DEFAULT_PERSPECTIVE               = new KeyOf(String.class, "DEFAULT_PERSPECTIVE");

}
