/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import org.simantics.db.MetadataI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.UndoMetadata;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.DependencyChanges;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Write;
import org.simantics.db.service.CollectionSupport;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.adapters.AddMissingIdentifiers;
import org.simantics.modeling.adapters.ChangeHistoryUpdated;
import org.simantics.modeling.adapters.SkipChangeHistoryUpdate;
import org.simantics.modeling.utils.OntologicalRequirementEnforceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologicalRequirementTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntologicalRequirementTracker.class);
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_MODIFICATIONS = false;
    private static final boolean DEBUG_PROPAGATE = false;
    private Layer0 L0;
    private DiagramResource DIA;
    private boolean trace;
    private boolean debug;

    private void propagate(ReadGraph graph, Resource r, Set<Resource> rs) throws DatabaseException {
        if (!r.isPersistent()) {
            return;
        }
        if (!rs.add(r)) {
            return;
        }
        if (graph.isInstanceOf(r, this.L0.IndexRoot)) {
            return;
        }
        Resource owner = graph.getPossibleObject(r, this.L0.IsOwnedBy);
        if (owner == null) {
            return;
        }
        if (graph.isInstanceOf(r, this.DIA.DiagramContainer) && (owner = graph.getPossibleObject(owner, this.L0.PartOf)) == null) {
            return;
        }
        this.propagate(graph, owner, rs);
    }

    /*
     * WARNING - void declaration
     */
    public void update(ReadGraph graph, MetadataI metadata, DependencyChanges event) throws DatabaseException {
        this.trace = LOGGER.isTraceEnabled();
        this.debug = LOGGER.isDebugEnabled();
        boolean updateChangeHistory = false;
        boolean addMissingIdentifiers = true;
        if (metadata != null) {
            TreeMap metadataMap = metadata.getMetadata();
            boolean isUndo = metadataMap.containsKey(UndoMetadata.class.getName());
            boolean wasHistoryUpdate = metadataMap.containsKey(ChangeHistoryUpdated.class.getName());
            boolean skipChangeHistoryUpdate = metadataMap.containsKey(SkipChangeHistoryUpdate.class.getName());
            addMissingIdentifiers = metadataMap.containsKey(AddMissingIdentifiers.class.getName());
            if ((isUndo || wasHistoryUpdate || skipChangeHistoryUpdate) && !addMissingIdentifiers) {
                return;
            }
            updateChangeHistory = !skipChangeHistoryUpdate;
        }
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        Set work = cs.createSet();
        Set creates = cs.createSet();
        Set ids = cs.createSet();
        for (Resource model : event.modelChanges.keySet()) {
            DependencyChanges.Change[] changes = (DependencyChanges.Change[])event.modelChanges.get(model);
            if (changes == null || changes.length == 0) continue;
            DependencyChanges.Change[] changeArray = changes;
            int n = changes.length;
            int n2 = 0;
            while (n2 < n) {
                Resource r;
                DependencyChanges.Change change;
                DependencyChanges.Change c = changeArray[n2];
                if (updateChangeHistory && (change = c) instanceof DependencyChanges.ComponentModification) {
                    DependencyChanges.ComponentAddition cm;
                    DependencyChanges.ComponentModification cfr_ignored_0 = (DependencyChanges.ComponentModification)change;
                    DependencyChanges.ComponentModification cfr_ignored_1 = (DependencyChanges.ComponentModification)change;
                    r = cm.component;
                    this.propagate(graph, r, work);
                }
                if ((change = c) instanceof DependencyChanges.ComponentAddition) {
                    boolean hasGUID;
                    void ca;
                    DependencyChanges.ComponentAddition cfr_ignored_2 = (DependencyChanges.ComponentAddition)change;
                    DependencyChanges.ComponentAddition cfr_ignored_3 = (DependencyChanges.ComponentAddition)change;
                    r = ca.component;
                    if (updateChangeHistory) {
                        boolean modifyChangeInformation;
                        boolean hasChangeInformation = graph.hasStatement(r, MOD.changeInformation);
                        boolean bl = modifyChangeInformation = !hasChangeInformation && ModelingUtils.needsModificationInfo(graph, r);
                        if (modifyChangeInformation) {
                            creates.add(r);
                        }
                        this.propagate(graph, r, work);
                    }
                    if (!(hasGUID = graph.hasStatement(r, this.L0.identifier)) && ModelingUtils.needsIdentifier(graph, r)) {
                        ids.add(r);
                    }
                }
                ++n2;
            }
        }
        if (creates.isEmpty() && work.isEmpty() && ids.isEmpty()) {
            return;
        }
        Set modis = Collections.emptySet();
        if (updateChangeHistory && !work.isEmpty()) {
            modis = cs.createSet();
            for (Resource r : Layer0Utils.sortByCluster((ReadGraph)graph, (Collection)work)) {
                if (creates.contains(r) || !ModelingUtils.needsModificationInfo(graph, r)) continue;
                modis.add(r);
            }
        }
        if (!(modis.isEmpty() && creates.isEmpty() && ids.isEmpty())) {
            graph.asyncRequest((Write)new OntologicalRequirementEnforceRequest(creates, modis, ids));
        }
    }
}

