/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import java.util.Objects;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

public class FindSubscription
extends UniqueRead<Resource> {
    Resource model;
    String id;
    String label;

    public FindSubscription(Resource model, String id, String label) {
        this.model = model;
        this.id = id;
        this.label = label;
    }

    public Resource perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        for (Resource r : graph.getObjects(this.model, L0.ConsistsOf)) {
            String label;
            String name;
            if (!graph.isInstanceOf(r, MOD.Subscription) || this.id != null && !(name = (String)graph.getPossibleRelatedValue(r, L0.HasName)).equals(this.id) || this.label != null && !(label = (String)graph.getPossibleRelatedValue(r, L0.HasLabel)).equals(this.label)) continue;
            return r;
        }
        return null;
    }

    public int hashCode() {
        return this.model.hashCode() + (this.id != null ? this.id.hashCode() : 0) + (this.label != null ? this.label.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        FindSubscription r = (FindSubscription)((Object)object);
        if (!Objects.equals(this.id, r.id)) {
            return false;
        }
        return Objects.equals(this.label, r.label);
    }
}

