/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl.ontologymodule;

import gnu.trove.procedure.TObjectProcedure;
import java.util.Collection;
import java.util.Collections;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.modeling.scl.ontologymodule.OntologyModule;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.errors.Failure;
import org.simantics.scl.compiler.errors.Success;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.options.ModuleCompilationOptions;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OntologyModuleSourceRepository implements ModuleSourceRepository
{
    INSTANCE;

    private static final Logger LOGGER;

    static {
        LOGGER = LoggerFactory.getLogger(OntologyModuleSourceRepository.class);
    }

    public ModuleSource getModuleSource(final String moduleName, UpdateListener listener) {
        if (!moduleName.startsWith("http://")) {
            return null;
        }
        return new ModuleSource(){

            public double getPriority() {
                return -1.0;
            }

            public boolean isUpdateable() {
                return false;
            }

            public String getModuleName() {
                return moduleName;
            }

            public ClassLoader getClassLoader() {
                return this.getClass().getClassLoader();
            }

            public Failable<Module> compileModule(ModuleRepository environment, UpdateListener listener, ModuleCompilationOptions options) {
                try {
                    return new Success((Object)((Module)Simantics.getAvailableRequestProcessor().syncRequest((Read)new ModuleRequest(moduleName))));
                }
                catch (DatabaseException e) {
                    return new Failure((Exception)((Object)e));
                }
            }
        };
    }

    public void forAllModules(TObjectProcedure<String> procedure) {
    }

    public Collection<String> getModuleNames() {
        return Collections.emptyList();
    }

    static class ModuleRequest
    extends UnaryRead<String, Module> {
        public ModuleRequest(String moduleName) {
            super((Object)moduleName);
        }

        public Module perform(ReadGraph graph) throws DatabaseException {
            return new OntologyModule(graph, (String)this.parameter);
        }
    }
}

