/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.flags;

import gnu.trove.iterator.hash.TObjectHashIterator;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.flags.ExpandFlags;
import org.simantics.scl.commands.Commands;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.structural.stubs.StructuralResource2;

public class MergeFlags {
    public static String validateForMerge(ReadGraph g, List<Resource> flags) throws DatabaseException {
        if (flags.size() <= 1) {
            return "At least two flags must be chosen.";
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        for (Resource flag : flags) {
            if (g.hasStatement(flag, DIA.FlagIsJoinedBy)) continue;
            return "All flags are not joined to other flags.";
        }
        List<Resource> connectors = MergeFlags.getPossibleRelated(g, flags, DIA.Flag_ConnectionPoint);
        for (Resource connector : connectors) {
            if (connector != null) continue;
            return "All flags are not connected";
        }
        List<Resource> connections = MergeFlags.getConnection(g, flags, connectors);
        for (Resource connection : connections) {
            if (connection != null) continue;
            return "Invalid flag. Didn't find configuration connection.";
        }
        THashSet uniqueConnections = new THashSet(connections.size());
        for (Resource connection : connections) {
            uniqueConnections.add((Object)connection);
        }
        if (uniqueConnections.size() == 1) {
            return null;
        }
        TObjectHashIterator it = uniqueConnections.iterator();
        THashSet<CP> cps = MergeFlags.getConnectionPoints(g, STR, (Resource)it.next());
        while (it.hasNext()) {
            cps.retainAll(MergeFlags.getConnectionPoints(g, STR, (Resource)it.next()));
            if (!cps.isEmpty()) continue;
            return "Flags are not connected to a common terminal.";
        }
        return null;
    }

    private static THashSet<CP> getConnectionPoints(ReadGraph g, StructuralResource2 STR, Resource connection) throws DatabaseException {
        THashSet result = new THashSet();
        for (Statement stat : g.getStatements(connection, STR.Connects)) {
            result.add((Object)new CP(stat.getObject(), g.getInverse(stat.getPredicate())));
        }
        return result;
    }

    public static String merge(WriteGraph g, List<Resource> flags) throws DatabaseException {
        return (String)Commands.get((ReadGraph)g, (String)"Simantics/Flag/mergeFlags").execute((RequestProcessor)g, (Resource)g.syncRequest((Read)new IndexRoot(flags.get(0))), new Object[]{flags});
    }

    public static String mergeWithoutMetadata(WriteGraph g, List<Resource> flags) throws DatabaseException {
        THashMap groups = new THashMap();
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        for (Resource flag : flags) {
            Resource connectionType;
            Resource connector = g.getSingleObject(flag, DIA.Flag_ConnectionPoint);
            Resource connection = null;
            for (Resource temp : g.getObjects(connector, STR.Connects)) {
                if (temp.equals(flag)) continue;
                connection = temp;
                break;
            }
            if (connection == null) continue;
            Resource flagType = g.getSingleObject(flag, DIA.HasFlagType);
            Tuple2 tuple = new Tuple2((Object)flagType, (Object)(connectionType = g.getPossibleObject(connection, STR.HasConnectionType)));
            ArrayList<Resource> group = (ArrayList<Resource>)groups.get((Object)tuple);
            if (group == null) {
                group = new ArrayList<Resource>();
                groups.put((Object)tuple, group);
            }
            group.add(flag);
        }
        String errorMessage = "";
        for (ArrayList group : groups.values()) {
            String temp;
            if (group.size() <= 1 || (temp = MergeFlags.mergeAux(g, group)) == null) continue;
            errorMessage = temp;
        }
        return errorMessage;
    }

    private static String mergeAux(WriteGraph g, List<Resource> flags) throws DatabaseException {
        if (flags.size() <= 1) {
            return null;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        List<Resource> connectors = MergeFlags.getPossibleRelated((ReadGraph)g, flags, DIA.Flag_ConnectionPoint);
        for (Resource connector : connectors) {
            if (connector != null) continue;
            return "All flags are not connected";
        }
        List<Resource> connections = MergeFlags.getConnection((ReadGraph)g, flags, connectors);
        for (Resource connection : connections) {
            if (connection != null) continue;
            return "Invalid flag. Didn't find configuration connection.";
        }
        Resource canonicalFlag = flags.get(0);
        Resource canonicalConnection = connections.get(0);
        int i = 1;
        while (i < flags.size()) {
            Resource flag = flags.get(i);
            Resource connection = connections.get(i);
            for (Resource join : g.getObjects(flag, DIA.FlagIsJoinedBy)) {
                g.denyStatement(flag, DIA.FlagIsJoinedBy, join);
                g.claim(canonicalFlag, DIA.FlagIsJoinedBy, join);
                g.denyStatement(join, STR.Joins, connection);
                g.claim(join, STR.Joins, canonicalConnection);
            }
            MergeFlags.removeElement(g, flag);
            g.deny(connectors.get(i));
            ++i;
        }
        THashSet uniqueConnections = new THashSet(connections.size());
        int i2 = 1;
        while (i2 < connections.size()) {
            uniqueConnections.add((Object)connections.get(i2));
            ++i2;
        }
        for (Resource connection : uniqueConnections) {
            MergeFlags.cleanUpConnection(g, connection);
        }
        return null;
    }

    private static void cleanUpConnection(WriteGraph g, Resource connection) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        Resource diagramConnection = g.getSingleObject(connection, MOD.ConnectionToDiagramConnection);
        if (g.getObjects(connection, STR.IsJoinedBy).size() == 0 && g.getObjects(connection, STR.Connects).size() <= 1) {
            g.deny(connection);
            new ConnectionUtil(g).removeConnection(diagramConnection);
        } else {
            boolean modifiedSomething = true;
            while (modifiedSomething) {
                modifiedSomething = false;
                for (Resource routeNode : g.getObjects(diagramConnection, DIA.HasInteriorRouteNode)) {
                    if (g.getObjects(routeNode, DIA.AreConnected).size() > 1) continue;
                    g.deny(routeNode);
                    modifiedSomething = true;
                }
            }
        }
    }

    private static void removeElement(WriteGraph g, Resource element) throws DatabaseException {
        OrderedSetUtils.remove((WriteGraph)g, (Resource)OrderedSetUtils.getSingleOwnerList((ReadGraph)g, (Resource)element), (Resource)element);
        g.deny(element);
    }

    private static List<Resource> getConnection(ReadGraph g, List<Resource> flags, List<Resource> connectors) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>(flags.size());
        int i = 0;
        while (i < flags.size()) {
            result.add(MergeFlags.getConnection(g, flags.get(i), connectors.get(i)));
            ++i;
        }
        return result;
    }

    private static Resource getConnection(ReadGraph g, Resource flag, Resource connector) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        for (Resource diagramConnection : g.getObjects(connector, STR.Connects)) {
            if (flag.equals(diagramConnection)) continue;
            return g.getPossibleObject(diagramConnection, MOD.DiagramConnectionToConnection);
        }
        return null;
    }

    private static List<Resource> getPossibleRelated(ReadGraph g, List<Resource> subjects, Resource relation) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>(subjects.size());
        int i = 0;
        while (i < subjects.size()) {
            result.add(g.getPossibleObject(subjects.get(i), relation));
            ++i;
        }
        return result;
    }

    public static void expandFlagSet(ReadGraph graph, List<Resource> flags) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        THashSet connectionSet = new THashSet();
        for (Resource flag : flags) {
            for (Resource connector : graph.getObjects(flag, STR.IsConnectedTo)) {
                for (Resource connection : graph.getObjects(connector, STR.Connects)) {
                    if (connection.equals(flag)) continue;
                    connectionSet.add((Object)connection);
                }
            }
        }
        Resource[] resourceArray = (Resource[])connectionSet.toArray((Object[])new Resource[connectionSet.size()]);
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object connection = resourceArray[n2];
            for (Resource connector : graph.getObjects((Resource)connection, STR.IsConnectedTo)) {
                for (Statement stat : graph.getStatements(connector, STR.Connects)) {
                    if (stat.getObject().equals(connection)) continue;
                    for (Resource connector2 : graph.getObjects(stat.getObject(), graph.getInverse(stat.getPredicate()))) {
                        if (connector2.equals(connector)) continue;
                        for (Resource connection2 : graph.getObjects(connector2, STR.Connects)) {
                            if (!graph.isInstanceOf(connection2, DIA.Connection)) continue;
                            connectionSet.add((Object)connection2);
                        }
                    }
                }
            }
            ++n2;
        }
        THashSet visited = new THashSet(flags);
        for (Resource connection : connectionSet) {
            visited.add((Object)connection);
            for (Resource connector : graph.getObjects(connection, STR.IsConnectedTo)) {
                for (Resource flag : graph.getObjects(connector, STR.Connects)) {
                    if (!visited.add((Object)flag) || !graph.isInstanceOf(flag, DIA.Flag) || !graph.hasStatement(flag, DIA.FlagIsJoinedBy)) continue;
                    flags.add(flag);
                }
            }
        }
    }

    public static void collectFlagGroupsInComposite(ReadGraph g, Resource composite, ArrayList<ArrayList<Resource>> groups) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource diagram = g.getPossibleObject(composite, MOD.CompositeToDiagram);
        if (diagram == null) {
            return;
        }
        THashSet flags = new THashSet();
        for (Resource element : g.getObjects(diagram, L0.ConsistsOf)) {
            if (!g.isInstanceOf(element, DIA.Flag) || !g.hasStatement(element, DIA.FlagIsJoinedBy)) continue;
            flags.add((Object)element);
        }
        Resource[] resourceArray = (Resource[])flags.toArray((Object[])new Resource[flags.size()]);
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource flag = resourceArray[n2];
            if (flags.contains((Object)flag)) {
                ArrayList<Resource> group = new ArrayList<Resource>();
                group.add(flag);
                MergeFlags.expandFlagSet(g, group);
                flags.removeAll(group);
                if (group.size() > 1) {
                    groups.add(group);
                }
            }
            ++n2;
        }
    }

    public static void expandCompositeSet(ReadGraph g, THashSet<Resource> composites) throws DatabaseException {
        Resource[] resourceArray = (Resource[])composites.toArray((Object[])new Resource[composites.size()]);
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource composite = resourceArray[n2];
            MergeFlags.expandCompositeSet(g, composite, composites);
            ++n2;
        }
    }

    private static void expandCompositeSet(ReadGraph g, Resource composite, THashSet<Resource> composites) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        for (Resource child : g.getObjects(composite, L0.ConsistsOf)) {
            if (!g.isInstanceOf(child, STR.Composite) || !composites.add((Object)child)) continue;
            MergeFlags.expandCompositeSet(g, child, composites);
        }
    }

    public static String mergeFlags(WriteGraph graph, Resource diagram) throws DatabaseException {
        ArrayList<ArrayList<Resource>> groups = new ArrayList<ArrayList<Resource>>();
        MergeFlags.collectFlagGroupsInComposite((ReadGraph)graph, diagram, groups);
        for (ArrayList<Resource> group : groups) {
            MergeFlags.merge(graph, group);
        }
        return "Merged flags in diagram resource: " + diagram.toString() + " and name: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)diagram);
    }

    public static void expandFlags(WriteGraph graph, Resource diagram) throws DatabaseException {
        ArrayList<Resource> groups = new ArrayList<Resource>();
        ExpandFlags.collectGroupedFlags((ReadGraph)graph, diagram, groups);
        for (Resource group : groups) {
            ExpandFlags.expandFlag(graph, group);
        }
    }

    private static class CP {
        public final Resource component;
        public final Resource connectionPoint;

        public CP(Resource component, Resource connectionPoint) {
            this.component = component;
            this.connectionPoint = connectionPoint;
        }

        public int hashCode() {
            return this.component.hashCode() + 31 * this.connectionPoint.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CP other = (CP)obj;
            return this.component.equals(other.component) && this.connectionPoint.equals(other.connectionPoint);
        }
    }
}

