/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.utils;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.VariableException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.ui.ErrorLogger;

public final class RemoverUtils {
    public static ValidationResult validateFlagRemoval(ReadGraph graph, Resource flag) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource connectionRelation : graph.getObjects(flag, DIA.IsLiftedAs)) {
            ValidationResult result = RemoverUtils.validateConnectionRelationRemoval(graph, connectionRelation, null);
            if (!result.inUse()) continue;
            return result;
        }
        return new ValidationResult();
    }

    public static ValidationResult validateConnectionRelationRemoval(ReadGraph graph, Resource connectionRelation, Resource diagramConnectionRelation) throws DatabaseException {
        Resource componentType;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        ValidationResult result = new ValidationResult();
        String connectionRelationName = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)connectionRelation);
        result.connectionRelation = new NamedResource(connectionRelationName, connectionRelation);
        if (diagramConnectionRelation != null) {
            String diagramConnectionRelationName = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)diagramConnectionRelation);
            result.diagramConnectionRelation = new NamedResource(diagramConnectionRelationName, diagramConnectionRelation);
        }
        if ((componentType = (Resource)graph.sync((ReadInterface)new PossibleObjectWithType(connectionRelation, L0.PartOf, STR.ComponentType))) == null) {
            return result;
        }
        String componentTypeName = (String)graph.getPossibleRelatedValue(componentType, L0.HasName, (Binding)Bindings.STRING);
        if (componentTypeName == null) {
            return result;
        }
        result.componentType = new NamedResource(componentTypeName, componentType);
        THashSet indexRoots = new THashSet();
        Resource indexRoot = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(componentType));
        if (indexRoot == null) {
            return result;
        }
        String indexRootName = (String)graph.getPossibleRelatedValue(indexRoot, L0.HasName, (Binding)Bindings.STRING);
        if (indexRootName == null) {
            return result;
        }
        result.containingIndexRoot = new NamedResource(indexRootName, indexRoot);
        Resource model = (Resource)graph.sync((ReadInterface)new PossibleModel(indexRoot));
        if (model == null) {
            indexRoots.addAll(graph.getObjects(indexRoot, L0.IsLinkedTo_Inverse));
        } else {
            indexRoots.add(model);
        }
        for (Resource root : indexRoots) {
            RemoverUtils.validateConnectionRelationRemovalForIndexRoot(graph, root, connectionRelation, diagramConnectionRelation, result);
        }
        return result;
    }

    private static void validateConnectionRelationRemovalForIndexRoot(ReadGraph graph, Resource root, Resource connectionRelation, Resource diagramConnectionRelation, ValidationResult result) throws DatabaseException {
        String rootURI = graph.getPossibleURI(root);
        if (rootURI == null) {
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String rootName = (String)graph.getPossibleRelatedValue(root, L0.HasName, (Binding)Bindings.STRING);
        if (rootName == null) {
            return;
        }
        NamedResource namedRoot = new NamedResource(rootName, root);
        List components = QueryIndexUtils.searchByTypeShallow((ReadGraph)graph, (Resource)root, (Resource)result.componentType.getResource());
        if (components.isEmpty()) {
            return;
        }
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        for (Resource component : components) {
            String componentName = (String)graph.getPossibleRelatedValue(component, L0.HasName, (Binding)Bindings.STRING);
            block1: for (Resource connection : graph.getObjects(component, connectionRelation)) {
                if (!graph.isInstanceOf(connection, STR.Connection)) continue;
                if (diagramConnectionRelation != null) {
                    for (Resource element : graph.getObjects(component, MOD.ComponentToElement)) {
                        for (Resource diagramConnector : graph.getObjects(element, diagramConnectionRelation)) {
                            Resource diagramConnection = ConnectionUtil.tryGetConnection((ReadGraph)graph, (Resource)diagramConnector);
                            if (diagramConnection == null) continue;
                            Resource correspondingConnection = graph.getPossibleObject(diagramConnection, MOD.DiagramConnectionToConnection);
                            Resource correspondingConnectionSpecial = graph.getPossibleObject(diagramConnection, MOD.DiagramConnectionToConnectionSpecial);
                            if (!connection.equals(correspondingConnection) && !connection.equals(correspondingConnectionSpecial)) continue;
                            RemoverUtils.addUse(graph, component, componentName, namedRoot, rootURI, result);
                            continue block1;
                        }
                    }
                    continue;
                }
                RemoverUtils.addUse(graph, component, componentName, namedRoot, rootURI, result);
            }
        }
    }

    private static boolean addUse(ReadGraph graph, Resource component, String componentName, NamedResource namedRoot, String rootURI, ValidationResult result) throws DatabaseException {
        Variable variable;
        String uri;
        block4: {
            uri = null;
            try {
                variable = Variables.getVariable((ReadGraph)graph, (Resource)component);
                if (result.usedVariables.add(variable)) break block4;
                return false;
            }
            catch (VariableException e) {
                ErrorLogger.defaultLogWarning((String)("Connection relation removal validation ignored invalid connection to component " + uri), (Throwable)e);
                return false;
            }
        }
        Use use = new Use();
        use.resource = component;
        use.name = componentName;
        use.variable = variable;
        use.root = namedRoot;
        uri = use.rootUri = use.variable.getURI(graph).replace(rootURI, "");
        use.context = Variables.getPossibleContext((ReadGraph)graph, (Variable)use.variable);
        if (use.context != null) {
            use.path = Variables.getPossibleRVI2((ReadGraph)graph, (Variable)variable);
        }
        result.uses.add(use);
        return true;
    }

    public static String formatError(ReadGraph graph, ValidationResult result) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        sb.append("Cannot remove connection point '" + result.connectionRelation.getName() + "'\nfrom user component '" + result.componentType.getName() + "'.").append("\nIt is used in " + result.uses.size() + " instance(s):\n\n");
        boolean absoluteUris = false;
        for (Use use : result.uses) {
            if (use.root.getResource().equals(result.containingIndexRoot.getResource())) continue;
            absoluteUris = true;
            break;
        }
        for (Use use : result.uses) {
            if (use.context != null) {
                if (absoluteUris) {
                    sb.append("/").append(use.root.getName()).append(use.rootUri);
                } else {
                    sb.append(use.path.toPossibleString(graph, use.context));
                }
            } else {
                if (absoluteUris) {
                    sb.append("/").append(use.root.getName());
                }
                sb.append(use.rootUri);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static class Use {
        public String name;
        public Resource resource;
        public Variable variable;
        public Variable context;
        public RVI path;
        public NamedResource root;
        public String rootUri;
    }

    public static class ValidationResult {
        public NamedResource containingIndexRoot;
        public NamedResource componentType;
        public NamedResource connectionRelation;
        public NamedResource diagramConnectionRelation;
        public Set<Variable> usedVariables = new THashSet();
        public Collection<Use> uses = new ArrayList<Use>();

        public boolean inUse() {
            return !this.uses.isEmpty();
        }
    }
}

